package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, SpotInstanceRequestId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSpotInstanceRequestsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    spotInstanceRequestIds: Optional[Iterable[SpotInstanceRequestId]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest = {
    import DescribeSpotInstanceRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        spotInstanceRequestIds.map(value =>
          value.map { item =>
            SpotInstanceRequestId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.spotInstanceRequestIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest.wrap(buildAwsValue())
}
object DescribeSpotInstanceRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest =
      zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        spotInstanceRequestIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def spotInstanceRequestIds: Optional[List[SpotInstanceRequestId]]
    def nextToken: Optional[String]
    def maxResults: Optional[Integer]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getSpotInstanceRequestIds
        : ZIO[Any, AwsError, List[SpotInstanceRequestId]] = AwsError
      .unwrapOptionField("spotInstanceRequestIds", spotInstanceRequestIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest
  ) extends zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val spotInstanceRequestIds: Optional[List[SpotInstanceRequestId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotInstanceRequestIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SpotInstanceRequestId(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest
  ): zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest.ReadOnly =
    new Wrapper(impl)
}
