package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeSecurityGroupsMaxResults,
  SecurityGroupName,
  SecurityGroupId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSecurityGroupsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    groupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    groupNames: Optional[Iterable[SecurityGroupName]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeSecurityGroupsMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest = {
    import DescribeSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        groupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupIds)
      .optionallyWith(
        groupNames.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupNames)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeSecurityGroupsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSecurityGroupsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSecurityGroupsRequest.wrap(buildAwsValue())
}
object DescribeSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSecurityGroupsRequest =
      zio.aws.ec2.model.DescribeSecurityGroupsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupIds.map(value => value),
        groupNames.map(value => value),
        dryRun.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def groupIds: Optional[List[SecurityGroupId]]
    def groupNames: Optional[List[SecurityGroupName]]
    def dryRun: Optional[Boolean]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeSecurityGroupsMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groupIds", groupIds)
    def getGroupNames: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("groupNames", groupNames)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeSecurityGroupsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest
  ) extends zio.aws.ec2.model.DescribeSecurityGroupsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val groupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val groupNames: Optional[List[SecurityGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupName(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[DescribeSecurityGroupsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeSecurityGroupsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest
  ): zio.aws.ec2.model.DescribeSecurityGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
