package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{PrefixListResourceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePrefixListsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    prefixListIds: Optional[Iterable[PrefixListResourceId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest = {
    import DescribePrefixListsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            PrefixListResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePrefixListsRequest.ReadOnly =
    zio.aws.ec2.model.DescribePrefixListsRequest.wrap(buildAwsValue())
}
object DescribePrefixListsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePrefixListsRequest =
      zio.aws.ec2.model.DescribePrefixListsRequest(
        dryRun.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        prefixListIds.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def prefixListIds: Optional[List[PrefixListResourceId]]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefixListIds: ZIO[Any, AwsError, List[PrefixListResourceId]] =
      AwsError.unwrapOptionField("prefixListIds", prefixListIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest
  ) extends zio.aws.ec2.model.DescribePrefixListsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val prefixListIds: Optional[List[PrefixListResourceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.PrefixListResourceId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest
  ): zio.aws.ec2.model.DescribePrefixListsRequest.ReadOnly = new Wrapper(impl)
}
