package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeInternetGatewaysMaxResults,
  InternetGatewayId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeInternetGatewaysRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    internetGatewayIds: Optional[Iterable[InternetGatewayId]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeInternetGatewaysMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest = {
    import DescribeInternetGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        internetGatewayIds.map(value =>
          value.map { item =>
            InternetGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.internetGatewayIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeInternetGatewaysMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInternetGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInternetGatewaysRequest.wrap(buildAwsValue())
}
object DescribeInternetGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInternetGatewaysRequest =
      zio.aws.ec2.model.DescribeInternetGatewaysRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        internetGatewayIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def internetGatewayIds: Optional[List[InternetGatewayId]]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeInternetGatewaysMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInternetGatewayIds: ZIO[Any, AwsError, List[InternetGatewayId]] =
      AwsError.unwrapOptionField("internetGatewayIds", internetGatewayIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeInternetGatewaysMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeInternetGatewaysRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val internetGatewayIds: Optional[List[InternetGatewayId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internetGatewayIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.InternetGatewayId(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[DescribeInternetGatewaysMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeInternetGatewaysMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest
  ): zio.aws.ec2.model.DescribeInternetGatewaysRequest.ReadOnly = new Wrapper(
    impl
  )
}
