package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CustomerGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCustomerGatewaysRequest(
    customerGatewayIds: Optional[Iterable[CustomerGatewayId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest = {
    import DescribeCustomerGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest
      .builder()
      .optionallyWith(
        customerGatewayIds.map(value =>
          value.map { item =>
            CustomerGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customerGatewayIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeCustomerGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCustomerGatewaysRequest.wrap(buildAwsValue())
}
object DescribeCustomerGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCustomerGatewaysRequest =
      zio.aws.ec2.model.DescribeCustomerGatewaysRequest(
        customerGatewayIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def customerGatewayIds: Optional[List[CustomerGatewayId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getCustomerGatewayIds: ZIO[Any, AwsError, List[CustomerGatewayId]] =
      AwsError.unwrapOptionField("customerGatewayIds", customerGatewayIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeCustomerGatewaysRequest.ReadOnly {
    override val customerGatewayIds: Optional[List[CustomerGatewayId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerGatewayIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.CustomerGatewayId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest
  ): zio.aws.ec2.model.DescribeCustomerGatewaysRequest.ReadOnly = new Wrapper(
    impl
  )
}
