package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeClientVpnEndpointMaxResults,
  ClientVpnEndpointId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnEndpointsRequest(
    clientVpnEndpointIds: Optional[Iterable[ClientVpnEndpointId]] =
      Optional.Absent,
    maxResults: Optional[DescribeClientVpnEndpointMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest = {
    import DescribeClientVpnEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest
      .builder()
      .optionallyWith(
        clientVpnEndpointIds.map(value =>
          value.map { item =>
            ClientVpnEndpointId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.clientVpnEndpointIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeClientVpnEndpointMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnEndpointsRequest.wrap(buildAwsValue())
}
object DescribeClientVpnEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest =
      zio.aws.ec2.model.DescribeClientVpnEndpointsRequest(
        clientVpnEndpointIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def clientVpnEndpointIds: Optional[List[ClientVpnEndpointId]]
    def maxResults: Optional[DescribeClientVpnEndpointMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getClientVpnEndpointIds: ZIO[Any, AwsError, List[ClientVpnEndpointId]] =
      AwsError.unwrapOptionField("clientVpnEndpointIds", clientVpnEndpointIds)
    def getMaxResults: ZIO[Any, AwsError, DescribeClientVpnEndpointMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest
  ) extends zio.aws.ec2.model.DescribeClientVpnEndpointsRequest.ReadOnly {
    override val clientVpnEndpointIds: Optional[List[ClientVpnEndpointId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientVpnEndpointIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ClientVpnEndpointId(item)
          }.toList
        )
    override val maxResults: Optional[DescribeClientVpnEndpointMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeClientVpnEndpointMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest
  ): zio.aws.ec2.model.DescribeClientVpnEndpointsRequest.ReadOnly = new Wrapper(
    impl
  )
}
