package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeCapacityBlockOfferingsMaxResults,
  MillisecondDateTime,
  Integer
}
import scala.jdk.CollectionConverters._
final case class DescribeCapacityBlockOfferingsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceType: String,
    instanceCount: Integer,
    startDateRange: Optional[MillisecondDateTime] = Optional.Absent,
    endDateRange: Optional[MillisecondDateTime] = Optional.Absent,
    capacityDurationHours: Integer,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeCapacityBlockOfferingsMaxResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest = {
    import DescribeCapacityBlockOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceType(instanceType: java.lang.String)
      .instanceCount(instanceCount: java.lang.Integer)
      .optionallyWith(
        startDateRange.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDateRange)
      .optionallyWith(
        endDateRange.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDateRange)
      .capacityDurationHours(capacityDurationHours: java.lang.Integer)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeCapacityBlockOfferingsMaxResults.unwrap(
            value
          ): java.lang.Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeCapacityBlockOfferingsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCapacityBlockOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeCapacityBlockOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCapacityBlockOfferingsRequest =
      zio.aws.ec2.model.DescribeCapacityBlockOfferingsRequest(
        dryRun.map(value => value),
        instanceType,
        instanceCount,
        startDateRange.map(value => value),
        endDateRange.map(value => value),
        capacityDurationHours,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def instanceType: String
    def instanceCount: Integer
    def startDateRange: Optional[MillisecondDateTime]
    def endDateRange: Optional[MillisecondDateTime]
    def capacityDurationHours: Integer
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeCapacityBlockOfferingsMaxResults]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(instanceCount)
    def getStartDateRange: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDateRange", startDateRange)
    def getEndDateRange: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDateRange", endDateRange)
    def getCapacityDurationHours: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(capacityDurationHours)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeCapacityBlockOfferingsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest
  ) extends zio.aws.ec2.model.DescribeCapacityBlockOfferingsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceType: String = impl.instanceType(): String
    override val instanceCount: Integer = impl.instanceCount(): Integer
    override val startDateRange: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startDateRange())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDateRange: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDateRange())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val capacityDurationHours: Integer =
      impl.capacityDurationHours(): Integer
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults
        : Optional[DescribeCapacityBlockOfferingsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeCapacityBlockOfferingsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest
  ): zio.aws.ec2.model.DescribeCapacityBlockOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
