package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.BundleId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeBundleTasksRequest(
    bundleIds: Optional[Iterable[BundleId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest = {
    import DescribeBundleTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest
      .builder()
      .optionallyWith(
        bundleIds.map(value =>
          value.map { item =>
            BundleId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bundleIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeBundleTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeBundleTasksRequest.wrap(buildAwsValue())
}
object DescribeBundleTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeBundleTasksRequest =
      zio.aws.ec2.model.DescribeBundleTasksRequest(
        bundleIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def bundleIds: Optional[List[BundleId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getBundleIds: ZIO[Any, AwsError, List[BundleId]] =
      AwsError.unwrapOptionField("bundleIds", bundleIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest
  ) extends zio.aws.ec2.model.DescribeBundleTasksRequest.ReadOnly {
    override val bundleIds: Optional[List[BundleId]] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.BundleId(item)
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest
  ): zio.aws.ec2.model.DescribeBundleTasksRequest.ReadOnly = new Wrapper(impl)
}
