package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{AddressMaxResults, NextToken, AllocationId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAddressesAttributeRequest(
    allocationIds: Optional[Iterable[AllocationId]] = Optional.Absent,
    attribute: Optional[zio.aws.ec2.model.AddressAttributeName] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[AddressMaxResults] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest = {
    import DescribeAddressesAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest
      .builder()
      .optionallyWith(
        allocationIds.map(value =>
          value.map { item =>
            AllocationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allocationIds)
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => AddressMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAddressesAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAddressesAttributeRequest.wrap(buildAwsValue())
}
object DescribeAddressesAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAddressesAttributeRequest =
      zio.aws.ec2.model.DescribeAddressesAttributeRequest(
        allocationIds.map(value => value),
        attribute.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        dryRun.map(value => value)
      )
    def allocationIds: Optional[List[AllocationId]]
    def attribute: Optional[zio.aws.ec2.model.AddressAttributeName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[AddressMaxResults]
    def dryRun: Optional[Boolean]
    def getAllocationIds: ZIO[Any, AwsError, List[AllocationId]] =
      AwsError.unwrapOptionField("allocationIds", allocationIds)
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.AddressAttributeName] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, AddressMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest
  ) extends zio.aws.ec2.model.DescribeAddressesAttributeRequest.ReadOnly {
    override val allocationIds: Optional[List[AllocationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.AllocationId(item)
          }.toList
        )
    override val attribute: Optional[zio.aws.ec2.model.AddressAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.ec2.model.AddressAttributeName.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Optional[AddressMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.AddressMaxResults(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest
  ): zio.aws.ec2.model.DescribeAddressesAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
