package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterTransitGatewayMulticastGroupMembersResponse(
    deregisteredMulticastGroupMembers: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse = {
    import DeregisterTransitGatewayMulticastGroupMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse
      .builder()
      .optionallyWith(
        deregisteredMulticastGroupMembers.map(value => value.buildAwsValue())
      )(_.deregisteredMulticastGroupMembers)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.ReadOnly =
    zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse
      .wrap(buildAwsValue())
}
object DeregisterTransitGatewayMulticastGroupMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse =
      zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse(
        deregisteredMulticastGroupMembers.map(value => value.asEditable)
      )
    def deregisteredMulticastGroupMembers: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers.ReadOnly
    ]
    def getDeregisteredMulticastGroupMembers: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deregisteredMulticastGroupMembers",
      deregisteredMulticastGroupMembers
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse
  ) extends zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.ReadOnly {
    override val deregisteredMulticastGroupMembers: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deregisteredMulticastGroupMembers())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse
  ): zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.ReadOnly =
    new Wrapper(impl)
}
