package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ConnectionNotificationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVpcEndpointConnectionNotificationsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    connectionNotificationIds: Iterable[ConnectionNotificationId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest = {
    import DeleteVpcEndpointConnectionNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .connectionNotificationIds(connectionNotificationIds.map { item =>
        ConnectionNotificationId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
      .wrap(buildAwsValue())
}
object DeleteVpcEndpointConnectionNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest =
      zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest(
        dryRun.map(value => value),
        connectionNotificationIds
      )
    def dryRun: Optional[Boolean]
    def connectionNotificationIds: List[ConnectionNotificationId]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getConnectionNotificationIds
        : ZIO[Any, Nothing, List[ConnectionNotificationId]] =
      ZIO.succeed(connectionNotificationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
  ) extends zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val connectionNotificationIds: List[ConnectionNotificationId] =
      impl
        .connectionNotificationIds()
        .asScala
        .map { item =>
          zio.aws.ec2.model.primitives.ConnectionNotificationId(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
  ): zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
