package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessTrustProviderId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVerifiedAccessTrustProviderRequest(
    verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId,
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest = {
    import DeleteVerifiedAccessTrustProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest
      .builder()
      .verifiedAccessTrustProviderId(
        VerifiedAccessTrustProviderId.unwrap(
          verifiedAccessTrustProviderId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVerifiedAccessTrustProviderRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVerifiedAccessTrustProviderRequest
      .wrap(buildAwsValue())
}
object DeleteVerifiedAccessTrustProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVerifiedAccessTrustProviderRequest =
      zio.aws.ec2.model.DeleteVerifiedAccessTrustProviderRequest(
        verifiedAccessTrustProviderId,
        dryRun.map(value => value),
        clientToken.map(value => value)
      )
    def verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId
    def dryRun: Optional[Boolean]
    def clientToken: Optional[String]
    def getVerifiedAccessTrustProviderId
        : ZIO[Any, Nothing, VerifiedAccessTrustProviderId] =
      ZIO.succeed(verifiedAccessTrustProviderId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest
  ) extends zio.aws.ec2.model.DeleteVerifiedAccessTrustProviderRequest.ReadOnly {
    override val verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessTrustProviderId(impl.verifiedAccessTrustProviderId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest
  ): zio.aws.ec2.model.DeleteVerifiedAccessTrustProviderRequest.ReadOnly =
    new Wrapper(impl)
}
