package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayMulticastDomainRequest(
    transitGatewayMulticastDomainId: TransitGatewayMulticastDomainId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest = {
    import DeleteTransitGatewayMulticastDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest
      .builder()
      .transitGatewayMulticastDomainId(
        TransitGatewayMulticastDomainId.unwrap(
          transitGatewayMulticastDomainId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayMulticastDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest =
      zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest(
        transitGatewayMulticastDomainId,
        dryRun.map(value => value)
      )
    def transitGatewayMulticastDomainId: TransitGatewayMulticastDomainId
    def dryRun: Optional[Boolean]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, Nothing, TransitGatewayMulticastDomainId] =
      ZIO.succeed(transitGatewayMulticastDomainId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : TransitGatewayMulticastDomainId = zio.aws.ec2.model.primitives
      .TransitGatewayMulticastDomainId(impl.transitGatewayMulticastDomainId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest.ReadOnly =
    new Wrapper(impl)
}
