package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolEc2Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePublicIpv4PoolRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    poolId: Ipv4PoolEc2Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest = {
    import DeletePublicIpv4PoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .poolId(Ipv4PoolEc2Id.unwrap(poolId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeletePublicIpv4PoolRequest.ReadOnly =
    zio.aws.ec2.model.DeletePublicIpv4PoolRequest.wrap(buildAwsValue())
}
object DeletePublicIpv4PoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeletePublicIpv4PoolRequest =
      zio.aws.ec2.model
        .DeletePublicIpv4PoolRequest(dryRun.map(value => value), poolId)
    def dryRun: Optional[Boolean]
    def poolId: Ipv4PoolEc2Id
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getPoolId: ZIO[Any, Nothing, Ipv4PoolEc2Id] = ZIO.succeed(poolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest
  ) extends zio.aws.ec2.model.DeletePublicIpv4PoolRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val poolId: Ipv4PoolEc2Id =
      zio.aws.ec2.model.primitives.Ipv4PoolEc2Id(impl.poolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest
  ): zio.aws.ec2.model.DeletePublicIpv4PoolRequest.ReadOnly = new Wrapper(impl)
}
