package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteInstanceConnectEndpointResponse(
    instanceConnectEndpoint: Optional[
      zio.aws.ec2.model.Ec2InstanceConnectEndpoint
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointResponse = {
    import DeleteInstanceConnectEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointResponse
      .builder()
      .optionallyWith(
        instanceConnectEndpoint.map(value => value.buildAwsValue())
      )(_.instanceConnectEndpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteInstanceConnectEndpointResponse.ReadOnly =
    zio.aws.ec2.model.DeleteInstanceConnectEndpointResponse
      .wrap(buildAwsValue())
}
object DeleteInstanceConnectEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteInstanceConnectEndpointResponse =
      zio.aws.ec2.model.DeleteInstanceConnectEndpointResponse(
        instanceConnectEndpoint.map(value => value.asEditable)
      )
    def instanceConnectEndpoint
        : Optional[zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly]
    def getInstanceConnectEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceConnectEndpoint",
      instanceConnectEndpoint
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointResponse
  ) extends zio.aws.ec2.model.DeleteInstanceConnectEndpointResponse.ReadOnly {
    override val instanceConnectEndpoint
        : Optional[zio.aws.ec2.model.Ec2InstanceConnectEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceConnectEndpoint())
        .map(value => zio.aws.ec2.model.Ec2InstanceConnectEndpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointResponse
  ): zio.aws.ec2.model.DeleteInstanceConnectEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
