package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceConnectEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteInstanceConnectEndpointRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceConnectEndpointId: InstanceConnectEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest = {
    import DeleteInstanceConnectEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceConnectEndpointId(
        InstanceConnectEndpointId.unwrap(
          instanceConnectEndpointId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteInstanceConnectEndpointRequest.ReadOnly =
    zio.aws.ec2.model.DeleteInstanceConnectEndpointRequest.wrap(buildAwsValue())
}
object DeleteInstanceConnectEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteInstanceConnectEndpointRequest =
      zio.aws.ec2.model.DeleteInstanceConnectEndpointRequest(
        dryRun.map(value => value),
        instanceConnectEndpointId
      )
    def dryRun: Optional[Boolean]
    def instanceConnectEndpointId: InstanceConnectEndpointId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceConnectEndpointId
        : ZIO[Any, Nothing, InstanceConnectEndpointId] =
      ZIO.succeed(instanceConnectEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest
  ) extends zio.aws.ec2.model.DeleteInstanceConnectEndpointRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceConnectEndpointId: InstanceConnectEndpointId =
      zio.aws.ec2.model.primitives
        .InstanceConnectEndpointId(impl.instanceConnectEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest
  ): zio.aws.ec2.model.DeleteInstanceConnectEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
