package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFleetsResponse(
    successfulFleetDeletions: Optional[
      Iterable[zio.aws.ec2.model.DeleteFleetSuccessItem]
    ] = Optional.Absent,
    unsuccessfulFleetDeletions: Optional[
      Iterable[zio.aws.ec2.model.DeleteFleetErrorItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse = {
    import DeleteFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse
      .builder()
      .optionallyWith(
        successfulFleetDeletions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successfulFleetDeletions)
      .optionallyWith(
        unsuccessfulFleetDeletions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessfulFleetDeletions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFleetsResponse.ReadOnly =
    zio.aws.ec2.model.DeleteFleetsResponse.wrap(buildAwsValue())
}
object DeleteFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFleetsResponse =
      zio.aws.ec2.model.DeleteFleetsResponse(
        successfulFleetDeletions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessfulFleetDeletions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulFleetDeletions
        : Optional[List[zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly]]
    def unsuccessfulFleetDeletions
        : Optional[List[zio.aws.ec2.model.DeleteFleetErrorItem.ReadOnly]]
    def getSuccessfulFleetDeletions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "successfulFleetDeletions",
      successfulFleetDeletions
    )
    def getUnsuccessfulFleetDeletions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DeleteFleetErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unsuccessfulFleetDeletions",
      unsuccessfulFleetDeletions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse
  ) extends zio.aws.ec2.model.DeleteFleetsResponse.ReadOnly {
    override val successfulFleetDeletions
        : Optional[List[zio.aws.ec2.model.DeleteFleetSuccessItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successfulFleetDeletions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DeleteFleetSuccessItem.wrap(item)
          }.toList
        )
    override val unsuccessfulFleetDeletions
        : Optional[List[zio.aws.ec2.model.DeleteFleetErrorItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unsuccessfulFleetDeletions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DeleteFleetErrorItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse
  ): zio.aws.ec2.model.DeleteFleetsResponse.ReadOnly = new Wrapper(impl)
}
