package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFleetsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    fleetIds: Iterable[FleetId],
    terminateInstances: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest = {
    import DeleteFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .fleetIds(fleetIds.map { item =>
        FleetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .terminateInstances(terminateInstances: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFleetsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteFleetsRequest.wrap(buildAwsValue())
}
object DeleteFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFleetsRequest =
      zio.aws.ec2.model.DeleteFleetsRequest(
        dryRun.map(value => value),
        fleetIds,
        terminateInstances
      )
    def dryRun: Optional[Boolean]
    def fleetIds: List[FleetId]
    def terminateInstances: Boolean
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFleetIds: ZIO[Any, Nothing, List[FleetId]] = ZIO.succeed(fleetIds)
    def getTerminateInstances: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(terminateInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest
  ) extends zio.aws.ec2.model.DeleteFleetsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val fleetIds: List[FleetId] = impl
      .fleetIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.FleetId(item)
      }
      .toList
    override val terminateInstances: Boolean =
      impl.terminateInstances(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest
  ): zio.aws.ec2.model.DeleteFleetsRequest.ReadOnly = new Wrapper(impl)
}
