package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CarrierGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCarrierGatewayRequest(
    carrierGatewayId: CarrierGatewayId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest = {
    import DeleteCarrierGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest
      .builder()
      .carrierGatewayId(
        CarrierGatewayId.unwrap(carrierGatewayId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCarrierGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteCarrierGatewayRequest.wrap(buildAwsValue())
}
object DeleteCarrierGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCarrierGatewayRequest =
      zio.aws.ec2.model.DeleteCarrierGatewayRequest(
        carrierGatewayId,
        dryRun.map(value => value)
      )
    def carrierGatewayId: CarrierGatewayId
    def dryRun: Optional[Boolean]
    def getCarrierGatewayId: ZIO[Any, Nothing, CarrierGatewayId] =
      ZIO.succeed(carrierGatewayId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest
  ) extends zio.aws.ec2.model.DeleteCarrierGatewayRequest.ReadOnly {
    override val carrierGatewayId: CarrierGatewayId =
      zio.aws.ec2.model.primitives.CarrierGatewayId(impl.carrierGatewayId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest
  ): zio.aws.ec2.model.DeleteCarrierGatewayRequest.ReadOnly = new Wrapper(impl)
}
