package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayId,
  VpnGatewayId,
  CustomerGatewayId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpnConnectionRequest(
    customerGatewayId: CustomerGatewayId,
    `type`: String,
    vpnGatewayId: Optional[VpnGatewayId] = Optional.Absent,
    transitGatewayId: Optional[TransitGatewayId] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    options: Optional[zio.aws.ec2.model.VpnConnectionOptionsSpecification] =
      Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest = {
    import CreateVpnConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest
      .builder()
      .customerGatewayId(
        CustomerGatewayId.unwrap(customerGatewayId): java.lang.String
      )
      .`type`(`type`: java.lang.String)
      .optionallyWith(
        vpnGatewayId.map(value => VpnGatewayId.unwrap(value): java.lang.String)
      )(_.vpnGatewayId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpnConnectionRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpnConnectionRequest.wrap(buildAwsValue())
}
object CreateVpnConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpnConnectionRequest =
      zio.aws.ec2.model.CreateVpnConnectionRequest(
        customerGatewayId,
        `type`,
        vpnGatewayId.map(value => value),
        transitGatewayId.map(value => value),
        dryRun.map(value => value),
        options.map(value => value.asEditable),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customerGatewayId: CustomerGatewayId
    def `type`: String
    def vpnGatewayId: Optional[VpnGatewayId]
    def transitGatewayId: Optional[TransitGatewayId]
    def dryRun: Optional[Boolean]
    def options
        : Optional[zio.aws.ec2.model.VpnConnectionOptionsSpecification.ReadOnly]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getCustomerGatewayId: ZIO[Any, Nothing, CustomerGatewayId] =
      ZIO.succeed(customerGatewayId)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getVpnGatewayId: ZIO[Any, AwsError, VpnGatewayId] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpnConnectionOptionsSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest
  ) extends zio.aws.ec2.model.CreateVpnConnectionRequest.ReadOnly {
    override val customerGatewayId: CustomerGatewayId =
      zio.aws.ec2.model.primitives.CustomerGatewayId(impl.customerGatewayId())
    override val `type`: String = impl.`type`(): String
    override val vpnGatewayId: Optional[VpnGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnGatewayId())
      .map(value => zio.aws.ec2.model.primitives.VpnGatewayId(value))
    override val transitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val options: Optional[
      zio.aws.ec2.model.VpnConnectionOptionsSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        zio.aws.ec2.model.VpnConnectionOptionsSpecification.wrap(value)
      )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest
  ): zio.aws.ec2.model.CreateVpnConnectionRequest.ReadOnly = new Wrapper(impl)
}
