package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{NetmaskLength, IpamPoolId, Ipv6PoolEc2Id}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateVpcRequest(
    cidrBlock: Optional[String] = Optional.Absent,
    amazonProvidedIpv6CidrBlock: Optional[Boolean] = Optional.Absent,
    ipv6Pool: Optional[Ipv6PoolEc2Id] = Optional.Absent,
    ipv6CidrBlock: Optional[String] = Optional.Absent,
    ipv4IpamPoolId: Optional[IpamPoolId] = Optional.Absent,
    ipv4NetmaskLength: Optional[NetmaskLength] = Optional.Absent,
    ipv6IpamPoolId: Optional[IpamPoolId] = Optional.Absent,
    ipv6NetmaskLength: Optional[NetmaskLength] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] = Optional.Absent,
    ipv6CidrBlockNetworkBorderGroup: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcRequest = {
    import CreateVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcRequest
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(
        amazonProvidedIpv6CidrBlock.map(value => value: java.lang.Boolean)
      )(_.amazonProvidedIpv6CidrBlock)
      .optionallyWith(
        ipv6Pool.map(value => Ipv6PoolEc2Id.unwrap(value): java.lang.String)
      )(_.ipv6Pool)
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .optionallyWith(
        ipv4IpamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipv4IpamPoolId)
      .optionallyWith(
        ipv4NetmaskLength.map(value => NetmaskLength.unwrap(value): Integer)
      )(_.ipv4NetmaskLength)
      .optionallyWith(
        ipv6IpamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipv6IpamPoolId)
      .optionallyWith(
        ipv6NetmaskLength.map(value => NetmaskLength.unwrap(value): Integer)
      )(_.ipv6NetmaskLength)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(
        ipv6CidrBlockNetworkBorderGroup.map(value => value: java.lang.String)
      )(_.ipv6CidrBlockNetworkBorderGroup)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpcRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpcRequest.wrap(buildAwsValue())
}
object CreateVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcRequest =
      zio.aws.ec2.model.CreateVpcRequest(
        cidrBlock.map(value => value),
        amazonProvidedIpv6CidrBlock.map(value => value),
        ipv6Pool.map(value => value),
        ipv6CidrBlock.map(value => value),
        ipv4IpamPoolId.map(value => value),
        ipv4NetmaskLength.map(value => value),
        ipv6IpamPoolId.map(value => value),
        ipv6NetmaskLength.map(value => value),
        dryRun.map(value => value),
        instanceTenancy.map(value => value),
        ipv6CidrBlockNetworkBorderGroup.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cidrBlock: Optional[String]
    def amazonProvidedIpv6CidrBlock: Optional[Boolean]
    def ipv6Pool: Optional[Ipv6PoolEc2Id]
    def ipv6CidrBlock: Optional[String]
    def ipv4IpamPoolId: Optional[IpamPoolId]
    def ipv4NetmaskLength: Optional[NetmaskLength]
    def ipv6IpamPoolId: Optional[IpamPoolId]
    def ipv6NetmaskLength: Optional[NetmaskLength]
    def dryRun: Optional[Boolean]
    def instanceTenancy: Optional[zio.aws.ec2.model.Tenancy]
    def ipv6CidrBlockNetworkBorderGroup: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getAmazonProvidedIpv6CidrBlock: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "amazonProvidedIpv6CidrBlock",
        amazonProvidedIpv6CidrBlock
      )
    def getIpv6Pool: ZIO[Any, AwsError, Ipv6PoolEc2Id] =
      AwsError.unwrapOptionField("ipv6Pool", ipv6Pool)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getIpv4IpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipv4IpamPoolId", ipv4IpamPoolId)
    def getIpv4NetmaskLength: ZIO[Any, AwsError, NetmaskLength] =
      AwsError.unwrapOptionField("ipv4NetmaskLength", ipv4NetmaskLength)
    def getIpv6IpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipv6IpamPoolId", ipv6IpamPoolId)
    def getIpv6NetmaskLength: ZIO[Any, AwsError, NetmaskLength] =
      AwsError.unwrapOptionField("ipv6NetmaskLength", ipv6NetmaskLength)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getIpv6CidrBlockNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ipv6CidrBlockNetworkBorderGroup",
        ipv6CidrBlockNetworkBorderGroup
      )
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcRequest
  ) extends zio.aws.ec2.model.CreateVpcRequest.ReadOnly {
    override val cidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => value: String)
    override val amazonProvidedIpv6CidrBlock: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amazonProvidedIpv6CidrBlock())
        .map(value => value: Boolean)
    override val ipv6Pool: Optional[Ipv6PoolEc2Id] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Pool())
      .map(value => zio.aws.ec2.model.primitives.Ipv6PoolEc2Id(value))
    override val ipv6CidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlock())
      .map(value => value: String)
    override val ipv4IpamPoolId: Optional[IpamPoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4IpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipv4NetmaskLength: Optional[NetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv4NetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.NetmaskLength(value))
    override val ipv6IpamPoolId: Optional[IpamPoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6IpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipv6NetmaskLength: Optional[NetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6NetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.NetmaskLength(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTenancy())
        .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val ipv6CidrBlockNetworkBorderGroup: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6CidrBlockNetworkBorderGroup())
        .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcRequest
  ): zio.aws.ec2.model.CreateVpcRequest.ReadOnly = new Wrapper(impl)
}
