package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessInstanceRequest(
    description: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    fipsEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest = {
    import CreateVerifiedAccessInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(fipsEnabled.map(value => value: java.lang.Boolean))(
        _.fipsEnabled
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessInstanceRequest.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessInstanceRequest.wrap(buildAwsValue())
}
object CreateVerifiedAccessInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVerifiedAccessInstanceRequest =
      zio.aws.ec2.model.CreateVerifiedAccessInstanceRequest(
        description.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        dryRun.map(value => value),
        fipsEnabled.map(value => value)
      )
    def description: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def fipsEnabled: Optional[Boolean]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFipsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("fipsEnabled", fipsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest
  ) extends zio.aws.ec2.model.CreateVerifiedAccessInstanceRequest.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val fipsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.fipsEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest
  ): zio.aws.ec2.model.CreateVerifiedAccessInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
