package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkInterfacePermissionRequest(
    networkInterfaceId: NetworkInterfaceId,
    awsAccountId: Optional[String] = Optional.Absent,
    awsService: Optional[String] = Optional.Absent,
    permission: zio.aws.ec2.model.InterfacePermissionType,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest = {
    import CreateNetworkInterfacePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest
      .builder()
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(awsAccountId.map(value => value: java.lang.String))(
        _.awsAccountId
      )
      .optionallyWith(awsService.map(value => value: java.lang.String))(
        _.awsService
      )
      .permission(permission.unwrap)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest
      .wrap(buildAwsValue())
}
object CreateNetworkInterfacePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest =
      zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest(
        networkInterfaceId,
        awsAccountId.map(value => value),
        awsService.map(value => value),
        permission,
        dryRun.map(value => value)
      )
    def networkInterfaceId: NetworkInterfaceId
    def awsAccountId: Optional[String]
    def awsService: Optional[String]
    def permission: zio.aws.ec2.model.InterfacePermissionType
    def dryRun: Optional[Boolean]
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getAwsAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsService: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsService", awsService)
    def getPermission
        : ZIO[Any, Nothing, zio.aws.ec2.model.InterfacePermissionType] =
      ZIO.succeed(permission)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest
  ) extends zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest.ReadOnly {
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val awsAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => value: String)
    override val awsService: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsService())
      .map(value => value: String)
    override val permission: zio.aws.ec2.model.InterfacePermissionType =
      zio.aws.ec2.model.InterfacePermissionType.wrap(impl.permission())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest
  ): zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
