package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkInsightsPathResponse(
    networkInsightsPath: Optional[zio.aws.ec2.model.NetworkInsightsPath] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse = {
    import CreateNetworkInsightsPathResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse
      .builder()
      .optionallyWith(networkInsightsPath.map(value => value.buildAwsValue()))(
        _.networkInsightsPath
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNetworkInsightsPathResponse.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInsightsPathResponse.wrap(buildAwsValue())
}
object CreateNetworkInsightsPathResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInsightsPathResponse =
      zio.aws.ec2.model.CreateNetworkInsightsPathResponse(
        networkInsightsPath.map(value => value.asEditable)
      )
    def networkInsightsPath
        : Optional[zio.aws.ec2.model.NetworkInsightsPath.ReadOnly]
    def getNetworkInsightsPath
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInsightsPath.ReadOnly] =
      AwsError.unwrapOptionField("networkInsightsPath", networkInsightsPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse
  ) extends zio.aws.ec2.model.CreateNetworkInsightsPathResponse.ReadOnly {
    override val networkInsightsPath
        : Optional[zio.aws.ec2.model.NetworkInsightsPath.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsPath())
        .map(value => zio.aws.ec2.model.NetworkInsightsPath.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse
  ): zio.aws.ec2.model.CreateNetworkInsightsPathResponse.ReadOnly = new Wrapper(
    impl
  )
}
