package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateIpamResourceDiscoveryResponse(
    ipamResourceDiscovery: Optional[zio.aws.ec2.model.IpamResourceDiscovery] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryResponse = {
    import CreateIpamResourceDiscoveryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryResponse
      .builder()
      .optionallyWith(
        ipamResourceDiscovery.map(value => value.buildAwsValue())
      )(_.ipamResourceDiscovery)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateIpamResourceDiscoveryResponse.ReadOnly =
    zio.aws.ec2.model.CreateIpamResourceDiscoveryResponse.wrap(buildAwsValue())
}
object CreateIpamResourceDiscoveryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateIpamResourceDiscoveryResponse =
      zio.aws.ec2.model.CreateIpamResourceDiscoveryResponse(
        ipamResourceDiscovery.map(value => value.asEditable)
      )
    def ipamResourceDiscovery
        : Optional[zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly]
    def getIpamResourceDiscovery
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly] =
      AwsError.unwrapOptionField("ipamResourceDiscovery", ipamResourceDiscovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryResponse
  ) extends zio.aws.ec2.model.CreateIpamResourceDiscoveryResponse.ReadOnly {
    override val ipamResourceDiscovery
        : Optional[zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscovery())
        .map(value => zio.aws.ec2.model.IpamResourceDiscovery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryResponse
  ): zio.aws.ec2.model.CreateIpamResourceDiscoveryResponse.ReadOnly =
    new Wrapper(impl)
}
