package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelBundleTaskResponse(
    bundleTask: Optional[zio.aws.ec2.model.BundleTask] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse = {
    import CancelBundleTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse
      .builder()
      .optionallyWith(bundleTask.map(value => value.buildAwsValue()))(
        _.bundleTask
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelBundleTaskResponse.ReadOnly =
    zio.aws.ec2.model.CancelBundleTaskResponse.wrap(buildAwsValue())
}
object CancelBundleTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelBundleTaskResponse =
      zio.aws.ec2.model
        .CancelBundleTaskResponse(bundleTask.map(value => value.asEditable))
    def bundleTask: Optional[zio.aws.ec2.model.BundleTask.ReadOnly]
    def getBundleTask
        : ZIO[Any, AwsError, zio.aws.ec2.model.BundleTask.ReadOnly] =
      AwsError.unwrapOptionField("bundleTask", bundleTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse
  ) extends zio.aws.ec2.model.CancelBundleTaskResponse.ReadOnly {
    override val bundleTask: Optional[zio.aws.ec2.model.BundleTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bundleTask())
        .map(value => zio.aws.ec2.model.BundleTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse
  ): zio.aws.ec2.model.CancelBundleTaskResponse.ReadOnly = new Wrapper(impl)
}
