package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BundleInstanceRequest(
    instanceId: InstanceId,
    storage: zio.aws.ec2.model.Storage,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.BundleInstanceRequest = {
    import BundleInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.BundleInstanceRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .storage(storage.buildAwsValue())
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.BundleInstanceRequest.ReadOnly =
    zio.aws.ec2.model.BundleInstanceRequest.wrap(buildAwsValue())
}
object BundleInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.BundleInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.BundleInstanceRequest =
      zio.aws.ec2.model.BundleInstanceRequest(
        instanceId,
        storage.asEditable,
        dryRun.map(value => value)
      )
    def instanceId: InstanceId
    def storage: zio.aws.ec2.model.Storage.ReadOnly
    def dryRun: Optional[Boolean]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getStorage: ZIO[Any, Nothing, zio.aws.ec2.model.Storage.ReadOnly] =
      ZIO.succeed(storage)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.BundleInstanceRequest
  ) extends zio.aws.ec2.model.BundleInstanceRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val storage: zio.aws.ec2.model.Storage.ReadOnly =
      zio.aws.ec2.model.Storage.wrap(impl.storage())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.BundleInstanceRequest
  ): zio.aws.ec2.model.BundleInstanceRequest.ReadOnly = new Wrapper(impl)
}
