package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{AssetId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AllocateHostsRequest(
    autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement] = Optional.Absent,
    availabilityZone: String,
    clientToken: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    instanceFamily: Optional[String] = Optional.Absent,
    quantity: Optional[Integer] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    hostRecovery: Optional[zio.aws.ec2.model.HostRecovery] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    hostMaintenance: Optional[zio.aws.ec2.model.HostMaintenance] =
      Optional.Absent,
    assetIds: Optional[Iterable[AssetId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateHostsRequest = {
    import AllocateHostsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateHostsRequest
      .builder()
      .optionallyWith(autoPlacement.map(value => value.unwrap))(_.autoPlacement)
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(quantity.map(value => value: java.lang.Integer))(
        _.quantity
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(hostRecovery.map(value => value.unwrap))(_.hostRecovery)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(hostMaintenance.map(value => value.unwrap))(
        _.hostMaintenance
      )
      .optionallyWith(
        assetIds.map(value =>
          value.map { item =>
            AssetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.assetIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateHostsRequest.ReadOnly =
    zio.aws.ec2.model.AllocateHostsRequest.wrap(buildAwsValue())
}
object AllocateHostsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateHostsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateHostsRequest =
      zio.aws.ec2.model.AllocateHostsRequest(
        autoPlacement.map(value => value),
        availabilityZone,
        clientToken.map(value => value),
        instanceType.map(value => value),
        instanceFamily.map(value => value),
        quantity.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostRecovery.map(value => value),
        outpostArn.map(value => value),
        hostMaintenance.map(value => value),
        assetIds.map(value => value)
      )
    def autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement]
    def availabilityZone: String
    def clientToken: Optional[String]
    def instanceType: Optional[String]
    def instanceFamily: Optional[String]
    def quantity: Optional[Integer]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def hostRecovery: Optional[zio.aws.ec2.model.HostRecovery]
    def outpostArn: Optional[String]
    def hostMaintenance: Optional[zio.aws.ec2.model.HostMaintenance]
    def assetIds: Optional[List[AssetId]]
    def getAutoPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.AutoPlacement] =
      AwsError.unwrapOptionField("autoPlacement", autoPlacement)
    def getAvailabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZone)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getQuantity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("quantity", quantity)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getHostRecovery: ZIO[Any, AwsError, zio.aws.ec2.model.HostRecovery] =
      AwsError.unwrapOptionField("hostRecovery", hostRecovery)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getHostMaintenance
        : ZIO[Any, AwsError, zio.aws.ec2.model.HostMaintenance] =
      AwsError.unwrapOptionField("hostMaintenance", hostMaintenance)
    def getAssetIds: ZIO[Any, AwsError, List[AssetId]] =
      AwsError.unwrapOptionField("assetIds", assetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateHostsRequest
  ) extends zio.aws.ec2.model.AllocateHostsRequest.ReadOnly {
    override val autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoPlacement())
        .map(value => zio.aws.ec2.model.AutoPlacement.wrap(value))
    override val availabilityZone: String = impl.availabilityZone(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val instanceFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFamily())
      .map(value => value: String)
    override val quantity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.quantity())
      .map(value => value: Integer)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val hostRecovery: Optional[zio.aws.ec2.model.HostRecovery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostRecovery())
        .map(value => zio.aws.ec2.model.HostRecovery.wrap(value))
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val hostMaintenance: Optional[zio.aws.ec2.model.HostMaintenance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostMaintenance())
        .map(value => zio.aws.ec2.model.HostMaintenance.wrap(value))
    override val assetIds: Optional[List[AssetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.assetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.AssetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateHostsRequest
  ): zio.aws.ec2.model.AllocateHostsRequest.ReadOnly = new Wrapper(impl)
}
