package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Ipv4PoolEc2Id, PublicIpAddress}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AllocateAddressRequest(
    domain: Optional[zio.aws.ec2.model.DomainType] = Optional.Absent,
    address: Optional[PublicIpAddress] = Optional.Absent,
    publicIpv4Pool: Optional[Ipv4PoolEc2Id] = Optional.Absent,
    networkBorderGroup: Optional[String] = Optional.Absent,
    customerOwnedIpv4Pool: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateAddressRequest = {
    import AllocateAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateAddressRequest
      .builder()
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(
        address.map(value => PublicIpAddress.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(
        publicIpv4Pool.map(value =>
          Ipv4PoolEc2Id.unwrap(value): java.lang.String
        )
      )(_.publicIpv4Pool)
      .optionallyWith(networkBorderGroup.map(value => value: java.lang.String))(
        _.networkBorderGroup
      )
      .optionallyWith(
        customerOwnedIpv4Pool.map(value => value: java.lang.String)
      )(_.customerOwnedIpv4Pool)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateAddressRequest.ReadOnly =
    zio.aws.ec2.model.AllocateAddressRequest.wrap(buildAwsValue())
}
object AllocateAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateAddressRequest =
      zio.aws.ec2.model.AllocateAddressRequest(
        domain.map(value => value),
        address.map(value => value),
        publicIpv4Pool.map(value => value),
        networkBorderGroup.map(value => value),
        customerOwnedIpv4Pool.map(value => value),
        dryRun.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domain: Optional[zio.aws.ec2.model.DomainType]
    def address: Optional[PublicIpAddress]
    def publicIpv4Pool: Optional[Ipv4PoolEc2Id]
    def networkBorderGroup: Optional[String]
    def customerOwnedIpv4Pool: Optional[String]
    def dryRun: Optional[Boolean]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getDomain: ZIO[Any, AwsError, zio.aws.ec2.model.DomainType] =
      AwsError.unwrapOptionField("domain", domain)
    def getAddress: ZIO[Any, AwsError, PublicIpAddress] =
      AwsError.unwrapOptionField("address", address)
    def getPublicIpv4Pool: ZIO[Any, AwsError, Ipv4PoolEc2Id] =
      AwsError.unwrapOptionField("publicIpv4Pool", publicIpv4Pool)
    def getNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateAddressRequest
  ) extends zio.aws.ec2.model.AllocateAddressRequest.ReadOnly {
    override val domain: Optional[zio.aws.ec2.model.DomainType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.ec2.model.DomainType.wrap(value))
    override val address: Optional[PublicIpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => zio.aws.ec2.model.primitives.PublicIpAddress(value))
    override val publicIpv4Pool: Optional[Ipv4PoolEc2Id] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIpv4Pool())
      .map(value => zio.aws.ec2.model.primitives.Ipv4PoolEc2Id(value))
    override val networkBorderGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkBorderGroup())
      .map(value => value: String)
    override val customerOwnedIpv4Pool: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerOwnedIpv4Pool())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateAddressRequest
  ): zio.aws.ec2.model.AllocateAddressRequest.ReadOnly = new Wrapper(impl)
}
