package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AccountAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.AccountAttributeName
}
object AccountAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AccountAttributeName
  ): zio.aws.ec2.model.AccountAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.AccountAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AccountAttributeName.SUPPORTED_PLATFORMS =>
      val r = `supported-platforms`
      r
    case software.amazon.awssdk.services.ec2.model.AccountAttributeName.DEFAULT_VPC =>
      val r = `default-vpc`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AccountAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AccountAttributeName =
      software.amazon.awssdk.services.ec2.model.AccountAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object `supported-platforms`
      extends zio.aws.ec2.model.AccountAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AccountAttributeName =
      software.amazon.awssdk.services.ec2.model.AccountAttributeName.SUPPORTED_PLATFORMS
  }
  case object `default-vpc` extends zio.aws.ec2.model.AccountAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AccountAttributeName =
      software.amazon.awssdk.services.ec2.model.AccountAttributeName.DEFAULT_VPC
  }
}
