package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcCidrBlockState(
    state: Optional[zio.aws.ec2.model.VpcCidrBlockStateCode] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcCidrBlockState = {
    import VpcCidrBlockState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcCidrBlockState
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcCidrBlockState.ReadOnly =
    zio.aws.ec2.model.VpcCidrBlockState.wrap(buildAwsValue())
}
object VpcCidrBlockState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcCidrBlockState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcCidrBlockState =
      zio.aws.ec2.model.VpcCidrBlockState(
        state.map(value => value),
        statusMessage.map(value => value)
      )
    def state: Optional[zio.aws.ec2.model.VpcCidrBlockStateCode]
    def statusMessage: Optional[String]
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VpcCidrBlockStateCode] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcCidrBlockState
  ) extends zio.aws.ec2.model.VpcCidrBlockState.ReadOnly {
    override val state: Optional[zio.aws.ec2.model.VpcCidrBlockStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.VpcCidrBlockStateCode.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcCidrBlockState
  ): zio.aws.ec2.model.VpcCidrBlockState.ReadOnly = new Wrapper(impl)
}
