package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSecurityGroupRuleDescriptionsEgressResponse(
    returnValue: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse = {
    import UpdateSecurityGroupRuleDescriptionsEgressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.ReadOnly =
    zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse
      .wrap(buildAwsValue())
}
object UpdateSecurityGroupRuleDescriptionsEgressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse =
      zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse(
        returnValue.map(value => value)
      )
    def returnValue: Optional[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse
  ) extends zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse
  ): zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.ReadOnly =
    new Wrapper(impl)
}
