package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DateTime,
  TransitGatewayId,
  TransitGatewayPolicyTableId
}
import scala.jdk.CollectionConverters._
final case class TransitGatewayPolicyTable(
    transitGatewayPolicyTableId: Optional[TransitGatewayPolicyTableId] =
      Optional.Absent,
    transitGatewayId: Optional[TransitGatewayId] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayPolicyTableState] =
      Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTable = {
    import TransitGatewayPolicyTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTable
      .builder()
      .optionallyWith(
        transitGatewayPolicyTableId.map(value =>
          TransitGatewayPolicyTableId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayPolicyTableId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPolicyTable.wrap(buildAwsValue())
}
object TransitGatewayPolicyTable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPolicyTable =
      zio.aws.ec2.model.TransitGatewayPolicyTable(
        transitGatewayPolicyTableId.map(value => value),
        transitGatewayId.map(value => value),
        state.map(value => value),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayPolicyTableId: Optional[TransitGatewayPolicyTableId]
    def transitGatewayId: Optional[TransitGatewayId]
    def state: Optional[zio.aws.ec2.model.TransitGatewayPolicyTableState]
    def creationTime: Optional[DateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayPolicyTableId
        : ZIO[Any, AwsError, TransitGatewayPolicyTableId] =
      AwsError.unwrapOptionField(
        "transitGatewayPolicyTableId",
        transitGatewayPolicyTableId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayPolicyTableState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTable
  ) extends zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly {
    override val transitGatewayPolicyTableId
        : Optional[TransitGatewayPolicyTableId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPolicyTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayPolicyTableId(value)
      )
    override val transitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayPolicyTableState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPolicyTableState.wrap(value)
        )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTable
  ): zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly = new Wrapper(impl)
}
