package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SupportedAdditionalProcessorFeature {
  def unwrap: software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature
}
object SupportedAdditionalProcessorFeature {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature
  ): zio.aws.ec2.model.SupportedAdditionalProcessorFeature = value match {
    case software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature.AMD_SEV_SNP =>
      val r = `amd-sev-snp`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.SupportedAdditionalProcessorFeature {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature =
      software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature.UNKNOWN_TO_SDK_VERSION
  }
  case object `amd-sev-snp`
      extends zio.aws.ec2.model.SupportedAdditionalProcessorFeature {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature =
      software.amazon.awssdk.services.ec2.model.SupportedAdditionalProcessorFeature.AMD_SEV_SNP
  }
}
