package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StaleIpPermission(
    fromPort: Optional[Integer] = Optional.Absent,
    ipProtocol: Optional[String] = Optional.Absent,
    ipRanges: Optional[Iterable[String]] = Optional.Absent,
    prefixListIds: Optional[Iterable[String]] = Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent,
    userIdGroupPairs: Optional[Iterable[zio.aws.ec2.model.UserIdGroupPair]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StaleIpPermission = {
    import StaleIpPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StaleIpPermission
      .builder()
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .optionallyWith(
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userIdGroupPairs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StaleIpPermission.ReadOnly =
    zio.aws.ec2.model.StaleIpPermission.wrap(buildAwsValue())
}
object StaleIpPermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StaleIpPermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StaleIpPermission =
      zio.aws.ec2.model.StaleIpPermission(
        fromPort.map(value => value),
        ipProtocol.map(value => value),
        ipRanges.map(value => value),
        prefixListIds.map(value => value),
        toPort.map(value => value),
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fromPort: Optional[Integer]
    def ipProtocol: Optional[String]
    def ipRanges: Optional[List[String]]
    def prefixListIds: Optional[List[String]]
    def toPort: Optional[Integer]
    def userIdGroupPairs
        : Optional[List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]]
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getIpRanges: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getPrefixListIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("prefixListIds", prefixListIds)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getUserIdGroupPairs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]] =
      AwsError.unwrapOptionField("userIdGroupPairs", userIdGroupPairs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StaleIpPermission
  ) extends zio.aws.ec2.model.StaleIpPermission.ReadOnly {
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val ipProtocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipProtocol())
      .map(value => value: String)
    override val ipRanges: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipRanges())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val prefixListIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
    override val userIdGroupPairs
        : Optional[List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userIdGroupPairs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.UserIdGroupPair.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StaleIpPermission
  ): zio.aws.ec2.model.StaleIpPermission.ReadOnly = new Wrapper(impl)
}
