package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.PlacementGroupName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SpotPlacement(
    availabilityZone: Optional[String] = Optional.Absent,
    groupName: Optional[PlacementGroupName] = Optional.Absent,
    tenancy: Optional[zio.aws.ec2.model.Tenancy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotPlacement = {
    import SpotPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotPlacement
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        groupName.map(value =>
          PlacementGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotPlacement.ReadOnly =
    zio.aws.ec2.model.SpotPlacement.wrap(buildAwsValue())
}
object SpotPlacement {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.SpotPlacement] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotPlacement =
      zio.aws.ec2.model.SpotPlacement(
        availabilityZone.map(value => value),
        groupName.map(value => value),
        tenancy.map(value => value)
      )
    def availabilityZone: Optional[String]
    def groupName: Optional[PlacementGroupName]
    def tenancy: Optional[zio.aws.ec2.model.Tenancy]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getGroupName: ZIO[Any, AwsError, PlacementGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotPlacement
  ) extends zio.aws.ec2.model.SpotPlacement.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val groupName: Optional[PlacementGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupName(value))
    override val tenancy: Optional[zio.aws.ec2.model.Tenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotPlacement
  ): zio.aws.ec2.model.SpotPlacement.ReadOnly = new Wrapper(impl)
}
