package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleOption(
    keyword: Optional[String] = Optional.Absent,
    settings: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.RuleOption = {
    import RuleOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RuleOption
      .builder()
      .optionallyWith(keyword.map(value => value: java.lang.String))(_.keyword)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RuleOption.ReadOnly =
    zio.aws.ec2.model.RuleOption.wrap(buildAwsValue())
}
object RuleOption {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.RuleOption] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RuleOption = zio.aws.ec2.model
      .RuleOption(keyword.map(value => value), settings.map(value => value))
    def keyword: Optional[String]
    def settings: Optional[List[String]]
    def getKeyword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyword", keyword)
    def getSettings: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RuleOption
  ) extends zio.aws.ec2.model.RuleOption.ReadOnly {
    override val keyword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyword())
      .map(value => value: String)
    override val settings: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.settings())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RuleOption
  ): zio.aws.ec2.model.RuleOption.ReadOnly = new Wrapper(impl)
}
