package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResetInstanceAttributeRequest(
    attribute: zio.aws.ec2.model.InstanceAttributeName,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest = {
    import ResetInstanceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetInstanceAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ResetInstanceAttributeRequest.wrap(buildAwsValue())
}
object ResetInstanceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetInstanceAttributeRequest =
      zio.aws.ec2.model.ResetInstanceAttributeRequest(attribute, instanceId)
    def attribute: zio.aws.ec2.model.InstanceAttributeName
    def instanceId: InstanceId
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.ec2.model.InstanceAttributeName] =
      ZIO.succeed(attribute)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest
  ) extends zio.aws.ec2.model.ResetInstanceAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.InstanceAttributeName =
      zio.aws.ec2.model.InstanceAttributeName.wrap(impl.attribute())
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest
  ): zio.aws.ec2.model.ResetInstanceAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
