package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PoolCidrBlock(cidr: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PoolCidrBlock = {
    import PoolCidrBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PoolCidrBlock
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PoolCidrBlock.ReadOnly =
    zio.aws.ec2.model.PoolCidrBlock.wrap(buildAwsValue())
}
object PoolCidrBlock {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PoolCidrBlock] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PoolCidrBlock =
      zio.aws.ec2.model.PoolCidrBlock(cidr.map(value => value))
    def cidr: Optional[String]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PoolCidrBlock
  ) extends zio.aws.ec2.model.PoolCidrBlock.ReadOnly {
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PoolCidrBlock
  ): zio.aws.ec2.model.PoolCidrBlock.ReadOnly = new Wrapper(impl)
}
