package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessInstanceLoggingConfigurationResponse(
    loggingConfiguration: Optional[
      zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse = {
    import ModifyVerifiedAccessInstanceLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessInstanceLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse =
      zio.aws.ec2.model
        .ModifyVerifiedAccessInstanceLoggingConfigurationResponse(
          loggingConfiguration.map(value => value.asEditable)
        )
    def loggingConfiguration: Optional[
      zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly
    ]
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration: Optional[
      zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfiguration())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse
  ): zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
