package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessEndpointPolicyRequest(
    verifiedAccessEndpointId: VerifiedAccessEndpointId,
    policyEnabled: Boolean,
    policyDocument: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest = {
    import ModifyVerifiedAccessEndpointPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
      .builder()
      .verifiedAccessEndpointId(
        VerifiedAccessEndpointId.unwrap(
          verifiedAccessEndpointId
        ): java.lang.String
      )
      .policyEnabled(policyEnabled: java.lang.Boolean)
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessEndpointPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest(
        verifiedAccessEndpointId,
        policyEnabled,
        policyDocument.map(value => value),
        clientToken.map(value => value)
      )
    def verifiedAccessEndpointId: VerifiedAccessEndpointId
    def policyEnabled: Boolean
    def policyDocument: Optional[String]
    def clientToken: Optional[String]
    def getVerifiedAccessEndpointId
        : ZIO[Any, Nothing, VerifiedAccessEndpointId] =
      ZIO.succeed(verifiedAccessEndpointId)
    def getPolicyEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(policyEnabled)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest.ReadOnly {
    override val verifiedAccessEndpointId: VerifiedAccessEndpointId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessEndpointId(impl.verifiedAccessEndpointId())
    override val policyEnabled: Boolean = impl.policyEnabled(): Boolean
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
