package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  InstanceId,
  Integer,
  PlacementGroupName,
  DedicatedHostId,
  PlacementGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyInstancePlacementRequest(
    affinity: Optional[zio.aws.ec2.model.Affinity] = Optional.Absent,
    groupName: Optional[PlacementGroupName] = Optional.Absent,
    hostId: Optional[DedicatedHostId] = Optional.Absent,
    instanceId: InstanceId,
    tenancy: Optional[zio.aws.ec2.model.HostTenancy] = Optional.Absent,
    partitionNumber: Optional[Integer] = Optional.Absent,
    hostResourceGroupArn: Optional[String] = Optional.Absent,
    groupId: Optional[PlacementGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest = {
    import ModifyInstancePlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest
      .builder()
      .optionallyWith(affinity.map(value => value.unwrap))(_.affinity)
      .optionallyWith(
        groupName.map(value =>
          PlacementGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        hostId.map(value => DedicatedHostId.unwrap(value): java.lang.String)
      )(_.hostId)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(partitionNumber.map(value => value: java.lang.Integer))(
        _.partitionNumber
      )
      .optionallyWith(
        hostResourceGroupArn.map(value => value: java.lang.String)
      )(_.hostResourceGroupArn)
      .optionallyWith(
        groupId.map(value => PlacementGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyInstancePlacementRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstancePlacementRequest.wrap(buildAwsValue())
}
object ModifyInstancePlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstancePlacementRequest =
      zio.aws.ec2.model.ModifyInstancePlacementRequest(
        affinity.map(value => value),
        groupName.map(value => value),
        hostId.map(value => value),
        instanceId,
        tenancy.map(value => value),
        partitionNumber.map(value => value),
        hostResourceGroupArn.map(value => value),
        groupId.map(value => value)
      )
    def affinity: Optional[zio.aws.ec2.model.Affinity]
    def groupName: Optional[PlacementGroupName]
    def hostId: Optional[DedicatedHostId]
    def instanceId: InstanceId
    def tenancy: Optional[zio.aws.ec2.model.HostTenancy]
    def partitionNumber: Optional[Integer]
    def hostResourceGroupArn: Optional[String]
    def groupId: Optional[PlacementGroupId]
    def getAffinity: ZIO[Any, AwsError, zio.aws.ec2.model.Affinity] =
      AwsError.unwrapOptionField("affinity", affinity)
    def getGroupName: ZIO[Any, AwsError, PlacementGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getHostId: ZIO[Any, AwsError, DedicatedHostId] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.HostTenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getPartitionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionNumber", partitionNumber)
    def getHostResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostResourceGroupArn", hostResourceGroupArn)
    def getGroupId: ZIO[Any, AwsError, PlacementGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest
  ) extends zio.aws.ec2.model.ModifyInstancePlacementRequest.ReadOnly {
    override val affinity: Optional[zio.aws.ec2.model.Affinity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.affinity())
        .map(value => zio.aws.ec2.model.Affinity.wrap(value))
    override val groupName: Optional[PlacementGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupName(value))
    override val hostId: Optional[DedicatedHostId] = zio.aws.core.internal
      .optionalFromNullable(impl.hostId())
      .map(value => zio.aws.ec2.model.primitives.DedicatedHostId(value))
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val tenancy: Optional[zio.aws.ec2.model.HostTenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value => zio.aws.ec2.model.HostTenancy.wrap(value))
    override val partitionNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.partitionNumber())
      .map(value => value: Integer)
    override val hostResourceGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostResourceGroupArn())
      .map(value => value: String)
    override val groupId: Optional[PlacementGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest
  ): zio.aws.ec2.model.ModifyInstancePlacementRequest.ReadOnly = new Wrapper(
    impl
  )
}
