package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamPoolCidrFailureCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode
}
object IpamPoolCidrFailureCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode
  ): zio.aws.ec2.model.IpamPoolCidrFailureCode = value match {
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode.CIDR_NOT_AVAILABLE =>
      val r = `cidr-not-available`
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode.LIMIT_EXCEEDED =>
      val r = `limit-exceeded`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamPoolCidrFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `cidr-not-available`
      extends zio.aws.ec2.model.IpamPoolCidrFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode.CIDR_NOT_AVAILABLE
  }
  case object `limit-exceeded`
      extends zio.aws.ec2.model.IpamPoolCidrFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode =
      software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureCode.LIMIT_EXCEEDED
  }
}
