package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class IpamAddressHistoryRecord(
    resourceOwnerId: Optional[String] = Optional.Absent,
    resourceRegion: Optional[String] = Optional.Absent,
    resourceType: Optional[zio.aws.ec2.model.IpamAddressHistoryResourceType] =
      Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceCidr: Optional[String] = Optional.Absent,
    resourceName: Optional[String] = Optional.Absent,
    resourceComplianceStatus: Optional[zio.aws.ec2.model.IpamComplianceStatus] =
      Optional.Absent,
    resourceOverlapStatus: Optional[zio.aws.ec2.model.IpamOverlapStatus] =
      Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    sampledStartTime: Optional[MillisecondDateTime] = Optional.Absent,
    sampledEndTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord = {
    import IpamAddressHistoryRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord
      .builder()
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(resourceRegion.map(value => value: java.lang.String))(
        _.resourceRegion
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceCidr.map(value => value: java.lang.String))(
        _.resourceCidr
      )
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .optionallyWith(resourceComplianceStatus.map(value => value.unwrap))(
        _.resourceComplianceStatus
      )
      .optionallyWith(resourceOverlapStatus.map(value => value.unwrap))(
        _.resourceOverlapStatus
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        sampledStartTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.sampledStartTime)
      .optionallyWith(
        sampledEndTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.sampledEndTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly =
    zio.aws.ec2.model.IpamAddressHistoryRecord.wrap(buildAwsValue())
}
object IpamAddressHistoryRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamAddressHistoryRecord =
      zio.aws.ec2.model.IpamAddressHistoryRecord(
        resourceOwnerId.map(value => value),
        resourceRegion.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceCidr.map(value => value),
        resourceName.map(value => value),
        resourceComplianceStatus.map(value => value),
        resourceOverlapStatus.map(value => value),
        vpcId.map(value => value),
        sampledStartTime.map(value => value),
        sampledEndTime.map(value => value)
      )
    def resourceOwnerId: Optional[String]
    def resourceRegion: Optional[String]
    def resourceType: Optional[zio.aws.ec2.model.IpamAddressHistoryResourceType]
    def resourceId: Optional[String]
    def resourceCidr: Optional[String]
    def resourceName: Optional[String]
    def resourceComplianceStatus
        : Optional[zio.aws.ec2.model.IpamComplianceStatus]
    def resourceOverlapStatus: Optional[zio.aws.ec2.model.IpamOverlapStatus]
    def vpcId: Optional[String]
    def sampledStartTime: Optional[MillisecondDateTime]
    def sampledEndTime: Optional[MillisecondDateTime]
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getResourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamAddressHistoryResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceCidr", resourceCidr)
    def getResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceComplianceStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamComplianceStatus] = AwsError
      .unwrapOptionField("resourceComplianceStatus", resourceComplianceStatus)
    def getResourceOverlapStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamOverlapStatus] =
      AwsError.unwrapOptionField("resourceOverlapStatus", resourceOverlapStatus)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSampledStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("sampledStartTime", sampledStartTime)
    def getSampledEndTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("sampledEndTime", sampledEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord
  ) extends zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly {
    override val resourceOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwnerId())
      .map(value => value: String)
    override val resourceRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceRegion())
      .map(value => value: String)
    override val resourceType
        : Optional[zio.aws.ec2.model.IpamAddressHistoryResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ec2.model.IpamAddressHistoryResourceType.wrap(value)
        )
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceCidr())
      .map(value => value: String)
    override val resourceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => value: String)
    override val resourceComplianceStatus
        : Optional[zio.aws.ec2.model.IpamComplianceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceComplianceStatus())
        .map(value => zio.aws.ec2.model.IpamComplianceStatus.wrap(value))
    override val resourceOverlapStatus
        : Optional[zio.aws.ec2.model.IpamOverlapStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOverlapStatus())
      .map(value => zio.aws.ec2.model.IpamOverlapStatus.wrap(value))
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val sampledStartTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampledStartTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val sampledEndTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampledEndTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord
  ): zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly = new Wrapper(impl)
}
