package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceType
}
object InstanceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceType
  ): zio.aws.ec2.model.InstanceType = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.A1_MEDIUM =>
      val r = `a1.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.A1_LARGE =>
      val r = `a1.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.A1_XLARGE =>
      val r = `a1.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.A1_2_XLARGE =>
      val r = `a1.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.A1_4_XLARGE =>
      val r = `a1.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.A1_METAL =>
      val r = `a1.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C1_MEDIUM =>
      val r = `c1.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C1_XLARGE =>
      val r = `c1.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C3_LARGE =>
      val r = `c3.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C3_XLARGE =>
      val r = `c3.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C3_2_XLARGE =>
      val r = `c3.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C3_4_XLARGE =>
      val r = `c3.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C3_8_XLARGE =>
      val r = `c3.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C4_LARGE =>
      val r = `c4.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C4_XLARGE =>
      val r = `c4.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C4_2_XLARGE =>
      val r = `c4.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C4_4_XLARGE =>
      val r = `c4.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C4_8_XLARGE =>
      val r = `c4.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_LARGE =>
      val r = `c5.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_XLARGE =>
      val r = `c5.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_2_XLARGE =>
      val r = `c5.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_4_XLARGE =>
      val r = `c5.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_9_XLARGE =>
      val r = `c5.9xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_12_XLARGE =>
      val r = `c5.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_18_XLARGE =>
      val r = `c5.18xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_24_XLARGE =>
      val r = `c5.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_METAL =>
      val r = `c5.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_LARGE =>
      val r = `c5a.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_XLARGE =>
      val r = `c5a.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_2_XLARGE =>
      val r = `c5a.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_4_XLARGE =>
      val r = `c5a.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_8_XLARGE =>
      val r = `c5a.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_12_XLARGE =>
      val r = `c5a.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_16_XLARGE =>
      val r = `c5a.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_24_XLARGE =>
      val r = `c5a.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_LARGE =>
      val r = `c5ad.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_XLARGE =>
      val r = `c5ad.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_2_XLARGE =>
      val r = `c5ad.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_4_XLARGE =>
      val r = `c5ad.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_8_XLARGE =>
      val r = `c5ad.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_12_XLARGE =>
      val r = `c5ad.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_16_XLARGE =>
      val r = `c5ad.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_24_XLARGE =>
      val r = `c5ad.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_LARGE =>
      val r = `c5d.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_XLARGE =>
      val r = `c5d.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_2_XLARGE =>
      val r = `c5d.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_4_XLARGE =>
      val r = `c5d.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_9_XLARGE =>
      val r = `c5d.9xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_12_XLARGE =>
      val r = `c5d.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_18_XLARGE =>
      val r = `c5d.18xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_24_XLARGE =>
      val r = `c5d.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_METAL =>
      val r = `c5d.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_LARGE =>
      val r = `c5n.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_XLARGE =>
      val r = `c5n.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_2_XLARGE =>
      val r = `c5n.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_4_XLARGE =>
      val r = `c5n.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_9_XLARGE =>
      val r = `c5n.9xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_18_XLARGE =>
      val r = `c5n.18xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_METAL =>
      val r = `c5n.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_MEDIUM =>
      val r = `c6g.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_LARGE =>
      val r = `c6g.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_XLARGE =>
      val r = `c6g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_2_XLARGE =>
      val r = `c6g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_4_XLARGE =>
      val r = `c6g.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_8_XLARGE =>
      val r = `c6g.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_12_XLARGE =>
      val r = `c6g.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_16_XLARGE =>
      val r = `c6g.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_METAL =>
      val r = `c6g.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_MEDIUM =>
      val r = `c6gd.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_LARGE =>
      val r = `c6gd.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_XLARGE =>
      val r = `c6gd.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_2_XLARGE =>
      val r = `c6gd.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_4_XLARGE =>
      val r = `c6gd.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_8_XLARGE =>
      val r = `c6gd.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_12_XLARGE =>
      val r = `c6gd.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_16_XLARGE =>
      val r = `c6gd.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_METAL =>
      val r = `c6gd.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_MEDIUM =>
      val r = `c6gn.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_LARGE =>
      val r = `c6gn.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_XLARGE =>
      val r = `c6gn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_2_XLARGE =>
      val r = `c6gn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_4_XLARGE =>
      val r = `c6gn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_8_XLARGE =>
      val r = `c6gn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_12_XLARGE =>
      val r = `c6gn.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_16_XLARGE =>
      val r = `c6gn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_LARGE =>
      val r = `c6i.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_XLARGE =>
      val r = `c6i.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_2_XLARGE =>
      val r = `c6i.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_4_XLARGE =>
      val r = `c6i.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_8_XLARGE =>
      val r = `c6i.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_12_XLARGE =>
      val r = `c6i.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_16_XLARGE =>
      val r = `c6i.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_24_XLARGE =>
      val r = `c6i.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_32_XLARGE =>
      val r = `c6i.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_METAL =>
      val r = `c6i.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.CC1_4_XLARGE =>
      val r = `cc1.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.CC2_8_XLARGE =>
      val r = `cc2.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.CG1_4_XLARGE =>
      val r = `cg1.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.CR1_8_XLARGE =>
      val r = `cr1.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D2_XLARGE =>
      val r = `d2.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D2_2_XLARGE =>
      val r = `d2.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D2_4_XLARGE =>
      val r = `d2.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D2_8_XLARGE =>
      val r = `d2.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_XLARGE =>
      val r = `d3.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_2_XLARGE =>
      val r = `d3.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_4_XLARGE =>
      val r = `d3.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_8_XLARGE =>
      val r = `d3.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_XLARGE =>
      val r = `d3en.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_2_XLARGE =>
      val r = `d3en.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_4_XLARGE =>
      val r = `d3en.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_6_XLARGE =>
      val r = `d3en.6xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_8_XLARGE =>
      val r = `d3en.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_12_XLARGE =>
      val r = `d3en.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.DL1_24_XLARGE =>
      val r = `dl1.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.F1_2_XLARGE =>
      val r = `f1.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.F1_4_XLARGE =>
      val r = `f1.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.F1_16_XLARGE =>
      val r = `f1.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G2_2_XLARGE =>
      val r = `g2.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G2_8_XLARGE =>
      val r = `g2.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G3_4_XLARGE =>
      val r = `g3.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G3_8_XLARGE =>
      val r = `g3.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G3_16_XLARGE =>
      val r = `g3.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G3_S_XLARGE =>
      val r = `g3s.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_XLARGE =>
      val r = `g4ad.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_2_XLARGE =>
      val r = `g4ad.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_4_XLARGE =>
      val r = `g4ad.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_8_XLARGE =>
      val r = `g4ad.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_16_XLARGE =>
      val r = `g4ad.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_XLARGE =>
      val r = `g4dn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_2_XLARGE =>
      val r = `g4dn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_4_XLARGE =>
      val r = `g4dn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_8_XLARGE =>
      val r = `g4dn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_12_XLARGE =>
      val r = `g4dn.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_16_XLARGE =>
      val r = `g4dn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_METAL =>
      val r = `g4dn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_XLARGE =>
      val r = `g5.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_2_XLARGE =>
      val r = `g5.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_4_XLARGE =>
      val r = `g5.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_8_XLARGE =>
      val r = `g5.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_12_XLARGE =>
      val r = `g5.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_16_XLARGE =>
      val r = `g5.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_24_XLARGE =>
      val r = `g5.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_48_XLARGE =>
      val r = `g5.48xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_XLARGE =>
      val r = `g5g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_2_XLARGE =>
      val r = `g5g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_4_XLARGE =>
      val r = `g5g.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_8_XLARGE =>
      val r = `g5g.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_16_XLARGE =>
      val r = `g5g.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_METAL =>
      val r = `g5g.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.HI1_4_XLARGE =>
      val r = `hi1.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.HPC6_A_48_XLARGE =>
      val r = `hpc6a.48xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.HS1_8_XLARGE =>
      val r = `hs1.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.H1_2_XLARGE =>
      val r = `h1.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.H1_4_XLARGE =>
      val r = `h1.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.H1_8_XLARGE =>
      val r = `h1.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.H1_16_XLARGE =>
      val r = `h1.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I2_XLARGE =>
      val r = `i2.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I2_2_XLARGE =>
      val r = `i2.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I2_4_XLARGE =>
      val r = `i2.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I2_8_XLARGE =>
      val r = `i2.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_LARGE =>
      val r = `i3.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_XLARGE =>
      val r = `i3.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_2_XLARGE =>
      val r = `i3.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_4_XLARGE =>
      val r = `i3.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_8_XLARGE =>
      val r = `i3.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_16_XLARGE =>
      val r = `i3.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_METAL =>
      val r = `i3.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_LARGE =>
      val r = `i3en.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_XLARGE =>
      val r = `i3en.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_2_XLARGE =>
      val r = `i3en.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_3_XLARGE =>
      val r = `i3en.3xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_6_XLARGE =>
      val r = `i3en.6xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_12_XLARGE =>
      val r = `i3en.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_24_XLARGE =>
      val r = `i3en.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_METAL =>
      val r = `i3en.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_LARGE =>
      val r = `im4gn.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_XLARGE =>
      val r = `im4gn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_2_XLARGE =>
      val r = `im4gn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_4_XLARGE =>
      val r = `im4gn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_8_XLARGE =>
      val r = `im4gn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_16_XLARGE =>
      val r = `im4gn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.INF1_XLARGE =>
      val r = `inf1.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.INF1_2_XLARGE =>
      val r = `inf1.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.INF1_6_XLARGE =>
      val r = `inf1.6xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.INF1_24_XLARGE =>
      val r = `inf1.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_MEDIUM =>
      val r = `is4gen.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_LARGE =>
      val r = `is4gen.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_XLARGE =>
      val r = `is4gen.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_2_XLARGE =>
      val r = `is4gen.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_4_XLARGE =>
      val r = `is4gen.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_8_XLARGE =>
      val r = `is4gen.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M1_SMALL =>
      val r = `m1.small`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M1_MEDIUM =>
      val r = `m1.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M1_LARGE =>
      val r = `m1.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M1_XLARGE =>
      val r = `m1.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M2_XLARGE =>
      val r = `m2.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M2_2_XLARGE =>
      val r = `m2.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M2_4_XLARGE =>
      val r = `m2.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M3_MEDIUM =>
      val r = `m3.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M3_LARGE =>
      val r = `m3.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M3_XLARGE =>
      val r = `m3.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M3_2_XLARGE =>
      val r = `m3.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M4_LARGE =>
      val r = `m4.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M4_XLARGE =>
      val r = `m4.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M4_2_XLARGE =>
      val r = `m4.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M4_4_XLARGE =>
      val r = `m4.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M4_10_XLARGE =>
      val r = `m4.10xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M4_16_XLARGE =>
      val r = `m4.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_LARGE =>
      val r = `m5.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_XLARGE =>
      val r = `m5.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_2_XLARGE =>
      val r = `m5.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_4_XLARGE =>
      val r = `m5.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_8_XLARGE =>
      val r = `m5.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_12_XLARGE =>
      val r = `m5.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_16_XLARGE =>
      val r = `m5.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_24_XLARGE =>
      val r = `m5.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_METAL =>
      val r = `m5.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_LARGE =>
      val r = `m5a.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_XLARGE =>
      val r = `m5a.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_2_XLARGE =>
      val r = `m5a.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_4_XLARGE =>
      val r = `m5a.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_8_XLARGE =>
      val r = `m5a.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_12_XLARGE =>
      val r = `m5a.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_16_XLARGE =>
      val r = `m5a.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_24_XLARGE =>
      val r = `m5a.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_LARGE =>
      val r = `m5ad.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_XLARGE =>
      val r = `m5ad.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_2_XLARGE =>
      val r = `m5ad.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_4_XLARGE =>
      val r = `m5ad.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_8_XLARGE =>
      val r = `m5ad.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_12_XLARGE =>
      val r = `m5ad.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_16_XLARGE =>
      val r = `m5ad.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_24_XLARGE =>
      val r = `m5ad.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_LARGE =>
      val r = `m5d.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_XLARGE =>
      val r = `m5d.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_2_XLARGE =>
      val r = `m5d.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_4_XLARGE =>
      val r = `m5d.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_8_XLARGE =>
      val r = `m5d.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_12_XLARGE =>
      val r = `m5d.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_16_XLARGE =>
      val r = `m5d.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_24_XLARGE =>
      val r = `m5d.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_METAL =>
      val r = `m5d.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_LARGE =>
      val r = `m5dn.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_XLARGE =>
      val r = `m5dn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_2_XLARGE =>
      val r = `m5dn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_4_XLARGE =>
      val r = `m5dn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_8_XLARGE =>
      val r = `m5dn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_12_XLARGE =>
      val r = `m5dn.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_16_XLARGE =>
      val r = `m5dn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_24_XLARGE =>
      val r = `m5dn.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_METAL =>
      val r = `m5dn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_LARGE =>
      val r = `m5n.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_XLARGE =>
      val r = `m5n.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_2_XLARGE =>
      val r = `m5n.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_4_XLARGE =>
      val r = `m5n.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_8_XLARGE =>
      val r = `m5n.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_12_XLARGE =>
      val r = `m5n.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_16_XLARGE =>
      val r = `m5n.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_24_XLARGE =>
      val r = `m5n.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_METAL =>
      val r = `m5n.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_LARGE =>
      val r = `m5zn.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_XLARGE =>
      val r = `m5zn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_2_XLARGE =>
      val r = `m5zn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_3_XLARGE =>
      val r = `m5zn.3xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_6_XLARGE =>
      val r = `m5zn.6xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_12_XLARGE =>
      val r = `m5zn.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_METAL =>
      val r = `m5zn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_LARGE =>
      val r = `m6a.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_XLARGE =>
      val r = `m6a.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_2_XLARGE =>
      val r = `m6a.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_4_XLARGE =>
      val r = `m6a.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_8_XLARGE =>
      val r = `m6a.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_12_XLARGE =>
      val r = `m6a.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_16_XLARGE =>
      val r = `m6a.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_24_XLARGE =>
      val r = `m6a.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_32_XLARGE =>
      val r = `m6a.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_48_XLARGE =>
      val r = `m6a.48xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_METAL =>
      val r = `m6g.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_MEDIUM =>
      val r = `m6g.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_LARGE =>
      val r = `m6g.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_XLARGE =>
      val r = `m6g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_2_XLARGE =>
      val r = `m6g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_4_XLARGE =>
      val r = `m6g.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_8_XLARGE =>
      val r = `m6g.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_12_XLARGE =>
      val r = `m6g.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_16_XLARGE =>
      val r = `m6g.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_METAL =>
      val r = `m6gd.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_MEDIUM =>
      val r = `m6gd.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_LARGE =>
      val r = `m6gd.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_XLARGE =>
      val r = `m6gd.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_2_XLARGE =>
      val r = `m6gd.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_4_XLARGE =>
      val r = `m6gd.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_8_XLARGE =>
      val r = `m6gd.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_12_XLARGE =>
      val r = `m6gd.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_16_XLARGE =>
      val r = `m6gd.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_LARGE =>
      val r = `m6i.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_XLARGE =>
      val r = `m6i.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_2_XLARGE =>
      val r = `m6i.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_4_XLARGE =>
      val r = `m6i.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_8_XLARGE =>
      val r = `m6i.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_12_XLARGE =>
      val r = `m6i.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_16_XLARGE =>
      val r = `m6i.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_24_XLARGE =>
      val r = `m6i.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_32_XLARGE =>
      val r = `m6i.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_METAL =>
      val r = `m6i.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.MAC1_METAL =>
      val r = `mac1.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P2_XLARGE =>
      val r = `p2.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P2_8_XLARGE =>
      val r = `p2.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P2_16_XLARGE =>
      val r = `p2.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P3_2_XLARGE =>
      val r = `p3.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P3_8_XLARGE =>
      val r = `p3.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P3_16_XLARGE =>
      val r = `p3.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P3_DN_24_XLARGE =>
      val r = `p3dn.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P4_D_24_XLARGE =>
      val r = `p4d.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R3_LARGE =>
      val r = `r3.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R3_XLARGE =>
      val r = `r3.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R3_2_XLARGE =>
      val r = `r3.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R3_4_XLARGE =>
      val r = `r3.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R3_8_XLARGE =>
      val r = `r3.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R4_LARGE =>
      val r = `r4.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R4_XLARGE =>
      val r = `r4.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R4_2_XLARGE =>
      val r = `r4.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R4_4_XLARGE =>
      val r = `r4.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R4_8_XLARGE =>
      val r = `r4.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R4_16_XLARGE =>
      val r = `r4.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_LARGE =>
      val r = `r5.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_XLARGE =>
      val r = `r5.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_2_XLARGE =>
      val r = `r5.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_4_XLARGE =>
      val r = `r5.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_8_XLARGE =>
      val r = `r5.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_12_XLARGE =>
      val r = `r5.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_16_XLARGE =>
      val r = `r5.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_24_XLARGE =>
      val r = `r5.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_METAL =>
      val r = `r5.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_LARGE =>
      val r = `r5a.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_XLARGE =>
      val r = `r5a.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_2_XLARGE =>
      val r = `r5a.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_4_XLARGE =>
      val r = `r5a.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_8_XLARGE =>
      val r = `r5a.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_12_XLARGE =>
      val r = `r5a.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_16_XLARGE =>
      val r = `r5a.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_24_XLARGE =>
      val r = `r5a.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_LARGE =>
      val r = `r5ad.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_XLARGE =>
      val r = `r5ad.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_2_XLARGE =>
      val r = `r5ad.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_4_XLARGE =>
      val r = `r5ad.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_8_XLARGE =>
      val r = `r5ad.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_12_XLARGE =>
      val r = `r5ad.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_16_XLARGE =>
      val r = `r5ad.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_24_XLARGE =>
      val r = `r5ad.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_LARGE =>
      val r = `r5b.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_XLARGE =>
      val r = `r5b.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_2_XLARGE =>
      val r = `r5b.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_4_XLARGE =>
      val r = `r5b.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_8_XLARGE =>
      val r = `r5b.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_12_XLARGE =>
      val r = `r5b.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_16_XLARGE =>
      val r = `r5b.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_24_XLARGE =>
      val r = `r5b.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_METAL =>
      val r = `r5b.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_LARGE =>
      val r = `r5d.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_XLARGE =>
      val r = `r5d.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_2_XLARGE =>
      val r = `r5d.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_4_XLARGE =>
      val r = `r5d.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_8_XLARGE =>
      val r = `r5d.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_12_XLARGE =>
      val r = `r5d.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_16_XLARGE =>
      val r = `r5d.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_24_XLARGE =>
      val r = `r5d.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_METAL =>
      val r = `r5d.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_LARGE =>
      val r = `r5dn.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_XLARGE =>
      val r = `r5dn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_2_XLARGE =>
      val r = `r5dn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_4_XLARGE =>
      val r = `r5dn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_8_XLARGE =>
      val r = `r5dn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_12_XLARGE =>
      val r = `r5dn.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_16_XLARGE =>
      val r = `r5dn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_24_XLARGE =>
      val r = `r5dn.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_METAL =>
      val r = `r5dn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_LARGE =>
      val r = `r5n.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_XLARGE =>
      val r = `r5n.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_2_XLARGE =>
      val r = `r5n.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_4_XLARGE =>
      val r = `r5n.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_8_XLARGE =>
      val r = `r5n.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_12_XLARGE =>
      val r = `r5n.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_16_XLARGE =>
      val r = `r5n.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_24_XLARGE =>
      val r = `r5n.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_METAL =>
      val r = `r5n.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_MEDIUM =>
      val r = `r6g.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_LARGE =>
      val r = `r6g.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_XLARGE =>
      val r = `r6g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_2_XLARGE =>
      val r = `r6g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_4_XLARGE =>
      val r = `r6g.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_8_XLARGE =>
      val r = `r6g.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_12_XLARGE =>
      val r = `r6g.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_16_XLARGE =>
      val r = `r6g.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_METAL =>
      val r = `r6g.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_MEDIUM =>
      val r = `r6gd.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_LARGE =>
      val r = `r6gd.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_XLARGE =>
      val r = `r6gd.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_2_XLARGE =>
      val r = `r6gd.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_4_XLARGE =>
      val r = `r6gd.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_8_XLARGE =>
      val r = `r6gd.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_12_XLARGE =>
      val r = `r6gd.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_16_XLARGE =>
      val r = `r6gd.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_METAL =>
      val r = `r6gd.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_LARGE =>
      val r = `r6i.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_XLARGE =>
      val r = `r6i.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_2_XLARGE =>
      val r = `r6i.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_4_XLARGE =>
      val r = `r6i.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_8_XLARGE =>
      val r = `r6i.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_12_XLARGE =>
      val r = `r6i.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_16_XLARGE =>
      val r = `r6i.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_24_XLARGE =>
      val r = `r6i.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_32_XLARGE =>
      val r = `r6i.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_METAL =>
      val r = `r6i.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T1_MICRO =>
      val r = `t1.micro`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T2_NANO =>
      val r = `t2.nano`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T2_MICRO =>
      val r = `t2.micro`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T2_SMALL =>
      val r = `t2.small`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T2_MEDIUM =>
      val r = `t2.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T2_LARGE =>
      val r = `t2.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T2_XLARGE =>
      val r = `t2.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T2_2_XLARGE =>
      val r = `t2.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_NANO =>
      val r = `t3.nano`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_MICRO =>
      val r = `t3.micro`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_SMALL =>
      val r = `t3.small`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_MEDIUM =>
      val r = `t3.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_LARGE =>
      val r = `t3.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_XLARGE =>
      val r = `t3.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_2_XLARGE =>
      val r = `t3.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_NANO =>
      val r = `t3a.nano`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_MICRO =>
      val r = `t3a.micro`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_SMALL =>
      val r = `t3a.small`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_MEDIUM =>
      val r = `t3a.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_LARGE =>
      val r = `t3a.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_XLARGE =>
      val r = `t3a.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_2_XLARGE =>
      val r = `t3a.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_NANO =>
      val r = `t4g.nano`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_MICRO =>
      val r = `t4g.micro`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_SMALL =>
      val r = `t4g.small`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_MEDIUM =>
      val r = `t4g.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_LARGE =>
      val r = `t4g.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_XLARGE =>
      val r = `t4g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_2_XLARGE =>
      val r = `t4g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_6_TB1_56_XLARGE =>
      val r = `u-6tb1.56xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_6_TB1_112_XLARGE =>
      val r = `u-6tb1.112xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_9_TB1_112_XLARGE =>
      val r = `u-9tb1.112xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_12_TB1_112_XLARGE =>
      val r = `u-12tb1.112xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_6_TB1_METAL =>
      val r = `u-6tb1.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_9_TB1_METAL =>
      val r = `u-9tb1.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_12_TB1_METAL =>
      val r = `u-12tb1.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_18_TB1_METAL =>
      val r = `u-18tb1.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_24_TB1_METAL =>
      val r = `u-24tb1.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.VT1_3_XLARGE =>
      val r = `vt1.3xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.VT1_6_XLARGE =>
      val r = `vt1.6xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.VT1_24_XLARGE =>
      val r = `vt1.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X1_16_XLARGE =>
      val r = `x1.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X1_32_XLARGE =>
      val r = `x1.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_XLARGE =>
      val r = `x1e.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_2_XLARGE =>
      val r = `x1e.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_4_XLARGE =>
      val r = `x1e.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_8_XLARGE =>
      val r = `x1e.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_16_XLARGE =>
      val r = `x1e.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_32_XLARGE =>
      val r = `x1e.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_2_XLARGE =>
      val r = `x2iezn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_4_XLARGE =>
      val r = `x2iezn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_6_XLARGE =>
      val r = `x2iezn.6xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_8_XLARGE =>
      val r = `x2iezn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_12_XLARGE =>
      val r = `x2iezn.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_METAL =>
      val r = `x2iezn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_MEDIUM =>
      val r = `x2gd.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_LARGE =>
      val r = `x2gd.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_XLARGE =>
      val r = `x2gd.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_2_XLARGE =>
      val r = `x2gd.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_4_XLARGE =>
      val r = `x2gd.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_8_XLARGE =>
      val r = `x2gd.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_12_XLARGE =>
      val r = `x2gd.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_16_XLARGE =>
      val r = `x2gd.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_METAL =>
      val r = `x2gd.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_LARGE =>
      val r = `z1d.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_XLARGE =>
      val r = `z1d.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_2_XLARGE =>
      val r = `z1d.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_3_XLARGE =>
      val r = `z1d.3xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_6_XLARGE =>
      val r = `z1d.6xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_12_XLARGE =>
      val r = `z1d.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_METAL =>
      val r = `z1d.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IDN_16_XLARGE =>
      val r = `x2idn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IDN_24_XLARGE =>
      val r = `x2idn.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IDN_32_XLARGE =>
      val r = `x2idn.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_XLARGE =>
      val r = `x2iedn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_2_XLARGE =>
      val r = `x2iedn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_4_XLARGE =>
      val r = `x2iedn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_8_XLARGE =>
      val r = `x2iedn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_16_XLARGE =>
      val r = `x2iedn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_24_XLARGE =>
      val r = `x2iedn.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_32_XLARGE =>
      val r = `x2iedn.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_LARGE =>
      val r = `c6a.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_XLARGE =>
      val r = `c6a.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_2_XLARGE =>
      val r = `c6a.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_4_XLARGE =>
      val r = `c6a.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_8_XLARGE =>
      val r = `c6a.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_12_XLARGE =>
      val r = `c6a.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_16_XLARGE =>
      val r = `c6a.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_24_XLARGE =>
      val r = `c6a.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_32_XLARGE =>
      val r = `c6a.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_48_XLARGE =>
      val r = `c6a.48xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_METAL =>
      val r = `c6a.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_METAL =>
      val r = `m6a.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_LARGE =>
      val r = `i4i.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_XLARGE =>
      val r = `i4i.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_2_XLARGE =>
      val r = `i4i.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_4_XLARGE =>
      val r = `i4i.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_8_XLARGE =>
      val r = `i4i.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_16_XLARGE =>
      val r = `i4i.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_32_XLARGE =>
      val r = `i4i.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_METAL =>
      val r = `i4i.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IDN_METAL =>
      val r = `x2idn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_METAL =>
      val r = `x2iedn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_MEDIUM =>
      val r = `c7g.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_LARGE =>
      val r = `c7g.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_XLARGE =>
      val r = `c7g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_2_XLARGE =>
      val r = `c7g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_4_XLARGE =>
      val r = `c7g.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_8_XLARGE =>
      val r = `c7g.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_12_XLARGE =>
      val r = `c7g.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_16_XLARGE =>
      val r = `c7g.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.MAC2_METAL =>
      val r = `mac2.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_LARGE =>
      val r = `c6id.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_XLARGE =>
      val r = `c6id.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_2_XLARGE =>
      val r = `c6id.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_4_XLARGE =>
      val r = `c6id.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_8_XLARGE =>
      val r = `c6id.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_12_XLARGE =>
      val r = `c6id.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_16_XLARGE =>
      val r = `c6id.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_24_XLARGE =>
      val r = `c6id.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_32_XLARGE =>
      val r = `c6id.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_METAL =>
      val r = `c6id.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_LARGE =>
      val r = `m6id.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_XLARGE =>
      val r = `m6id.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_2_XLARGE =>
      val r = `m6id.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_4_XLARGE =>
      val r = `m6id.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_8_XLARGE =>
      val r = `m6id.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_12_XLARGE =>
      val r = `m6id.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_16_XLARGE =>
      val r = `m6id.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_24_XLARGE =>
      val r = `m6id.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_32_XLARGE =>
      val r = `m6id.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_METAL =>
      val r = `m6id.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_LARGE =>
      val r = `r6id.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_XLARGE =>
      val r = `r6id.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_2_XLARGE =>
      val r = `r6id.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_4_XLARGE =>
      val r = `r6id.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_8_XLARGE =>
      val r = `r6id.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_12_XLARGE =>
      val r = `r6id.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_16_XLARGE =>
      val r = `r6id.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_24_XLARGE =>
      val r = `r6id.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_32_XLARGE =>
      val r = `r6id.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_METAL =>
      val r = `r6id.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_LARGE =>
      val r = `r6a.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_XLARGE =>
      val r = `r6a.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_2_XLARGE =>
      val r = `r6a.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_4_XLARGE =>
      val r = `r6a.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_8_XLARGE =>
      val r = `r6a.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_12_XLARGE =>
      val r = `r6a.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_16_XLARGE =>
      val r = `r6a.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_24_XLARGE =>
      val r = `r6a.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_32_XLARGE =>
      val r = `r6a.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_48_XLARGE =>
      val r = `r6a.48xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_METAL =>
      val r = `r6a.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.P4_DE_24_XLARGE =>
      val r = `p4de.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_3_TB1_56_XLARGE =>
      val r = `u-3tb1.56xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_18_TB1_112_XLARGE =>
      val r = `u-18tb1.112xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.U_24_TB1_112_XLARGE =>
      val r = `u-24tb1.112xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.TRN1_2_XLARGE =>
      val r = `trn1.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.TRN1_32_XLARGE =>
      val r = `trn1.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.HPC6_ID_32_XLARGE =>
      val r = `hpc6id.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_LARGE =>
      val r = `c6in.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_XLARGE =>
      val r = `c6in.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_2_XLARGE =>
      val r = `c6in.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_4_XLARGE =>
      val r = `c6in.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_8_XLARGE =>
      val r = `c6in.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_12_XLARGE =>
      val r = `c6in.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_16_XLARGE =>
      val r = `c6in.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_24_XLARGE =>
      val r = `c6in.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_32_XLARGE =>
      val r = `c6in.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_LARGE =>
      val r = `m6in.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_XLARGE =>
      val r = `m6in.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_2_XLARGE =>
      val r = `m6in.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_4_XLARGE =>
      val r = `m6in.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_8_XLARGE =>
      val r = `m6in.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_12_XLARGE =>
      val r = `m6in.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_16_XLARGE =>
      val r = `m6in.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_24_XLARGE =>
      val r = `m6in.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_32_XLARGE =>
      val r = `m6in.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_LARGE =>
      val r = `m6idn.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_XLARGE =>
      val r = `m6idn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_2_XLARGE =>
      val r = `m6idn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_4_XLARGE =>
      val r = `m6idn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_8_XLARGE =>
      val r = `m6idn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_12_XLARGE =>
      val r = `m6idn.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_16_XLARGE =>
      val r = `m6idn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_24_XLARGE =>
      val r = `m6idn.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_32_XLARGE =>
      val r = `m6idn.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_LARGE =>
      val r = `r6in.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_XLARGE =>
      val r = `r6in.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_2_XLARGE =>
      val r = `r6in.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_4_XLARGE =>
      val r = `r6in.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_8_XLARGE =>
      val r = `r6in.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_12_XLARGE =>
      val r = `r6in.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_16_XLARGE =>
      val r = `r6in.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_24_XLARGE =>
      val r = `r6in.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_32_XLARGE =>
      val r = `r6in.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_LARGE =>
      val r = `r6idn.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_XLARGE =>
      val r = `r6idn.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_2_XLARGE =>
      val r = `r6idn.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_4_XLARGE =>
      val r = `r6idn.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_8_XLARGE =>
      val r = `r6idn.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_12_XLARGE =>
      val r = `r6idn.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_16_XLARGE =>
      val r = `r6idn.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_24_XLARGE =>
      val r = `r6idn.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_32_XLARGE =>
      val r = `r6idn.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_METAL =>
      val r = `c7g.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_MEDIUM =>
      val r = `m7g.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_LARGE =>
      val r = `m7g.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_XLARGE =>
      val r = `m7g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_2_XLARGE =>
      val r = `m7g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_4_XLARGE =>
      val r = `m7g.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_8_XLARGE =>
      val r = `m7g.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_12_XLARGE =>
      val r = `m7g.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_16_XLARGE =>
      val r = `m7g.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_METAL =>
      val r = `m7g.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_MEDIUM =>
      val r = `r7g.medium`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_LARGE =>
      val r = `r7g.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_XLARGE =>
      val r = `r7g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_2_XLARGE =>
      val r = `r7g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_4_XLARGE =>
      val r = `r7g.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_8_XLARGE =>
      val r = `r7g.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_12_XLARGE =>
      val r = `r7g.12xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_16_XLARGE =>
      val r = `r7g.16xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_METAL =>
      val r = `r7g.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_METAL =>
      val r = `c6in.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_METAL =>
      val r = `m6in.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_METAL =>
      val r = `m6idn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_METAL =>
      val r = `r6in.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_METAL =>
      val r = `r6idn.metal`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.INF2_XLARGE =>
      val r = `inf2.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.INF2_8_XLARGE =>
      val r = `inf2.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.INF2_24_XLARGE =>
      val r = `inf2.24xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.INF2_48_XLARGE =>
      val r = `inf2.48xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.TRN1_N_32_XLARGE =>
      val r = `trn1n.32xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_LARGE =>
      val r = `i4g.large`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_XLARGE =>
      val r = `i4g.xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_2_XLARGE =>
      val r = `i4g.2xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_4_XLARGE =>
      val r = `i4g.4xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_8_XLARGE =>
      val r = `i4g.8xlarge`
      r
    case software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_16_XLARGE =>
      val r = `i4g.16xlarge`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `a1.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.A1_MEDIUM
  }
  case object `a1.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.A1_LARGE
  }
  case object `a1.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.A1_XLARGE
  }
  case object `a1.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.A1_2_XLARGE
  }
  case object `a1.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.A1_4_XLARGE
  }
  case object `a1.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.A1_METAL
  }
  case object `c1.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C1_MEDIUM
  }
  case object `c1.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C1_XLARGE
  }
  case object `c3.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C3_LARGE
  }
  case object `c3.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C3_XLARGE
  }
  case object `c3.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C3_2_XLARGE
  }
  case object `c3.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C3_4_XLARGE
  }
  case object `c3.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C3_8_XLARGE
  }
  case object `c4.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C4_LARGE
  }
  case object `c4.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C4_XLARGE
  }
  case object `c4.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C4_2_XLARGE
  }
  case object `c4.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C4_4_XLARGE
  }
  case object `c4.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C4_8_XLARGE
  }
  case object `c5.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_LARGE
  }
  case object `c5.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_XLARGE
  }
  case object `c5.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_2_XLARGE
  }
  case object `c5.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_4_XLARGE
  }
  case object `c5.9xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_9_XLARGE
  }
  case object `c5.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_12_XLARGE
  }
  case object `c5.18xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_18_XLARGE
  }
  case object `c5.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_24_XLARGE
  }
  case object `c5.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_METAL
  }
  case object `c5a.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_LARGE
  }
  case object `c5a.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_XLARGE
  }
  case object `c5a.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_2_XLARGE
  }
  case object `c5a.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_4_XLARGE
  }
  case object `c5a.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_8_XLARGE
  }
  case object `c5a.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_12_XLARGE
  }
  case object `c5a.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_16_XLARGE
  }
  case object `c5a.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_A_24_XLARGE
  }
  case object `c5ad.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_LARGE
  }
  case object `c5ad.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_XLARGE
  }
  case object `c5ad.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_2_XLARGE
  }
  case object `c5ad.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_4_XLARGE
  }
  case object `c5ad.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_8_XLARGE
  }
  case object `c5ad.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_12_XLARGE
  }
  case object `c5ad.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_16_XLARGE
  }
  case object `c5ad.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_AD_24_XLARGE
  }
  case object `c5d.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_LARGE
  }
  case object `c5d.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_XLARGE
  }
  case object `c5d.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_2_XLARGE
  }
  case object `c5d.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_4_XLARGE
  }
  case object `c5d.9xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_9_XLARGE
  }
  case object `c5d.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_12_XLARGE
  }
  case object `c5d.18xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_18_XLARGE
  }
  case object `c5d.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_24_XLARGE
  }
  case object `c5d.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_D_METAL
  }
  case object `c5n.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_LARGE
  }
  case object `c5n.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_XLARGE
  }
  case object `c5n.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_2_XLARGE
  }
  case object `c5n.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_4_XLARGE
  }
  case object `c5n.9xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_9_XLARGE
  }
  case object `c5n.18xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_18_XLARGE
  }
  case object `c5n.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C5_N_METAL
  }
  case object `c6g.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_MEDIUM
  }
  case object `c6g.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_LARGE
  }
  case object `c6g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_XLARGE
  }
  case object `c6g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_2_XLARGE
  }
  case object `c6g.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_4_XLARGE
  }
  case object `c6g.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_8_XLARGE
  }
  case object `c6g.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_12_XLARGE
  }
  case object `c6g.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_16_XLARGE
  }
  case object `c6g.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_G_METAL
  }
  case object `c6gd.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_MEDIUM
  }
  case object `c6gd.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_LARGE
  }
  case object `c6gd.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_XLARGE
  }
  case object `c6gd.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_2_XLARGE
  }
  case object `c6gd.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_4_XLARGE
  }
  case object `c6gd.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_8_XLARGE
  }
  case object `c6gd.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_12_XLARGE
  }
  case object `c6gd.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_16_XLARGE
  }
  case object `c6gd.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GD_METAL
  }
  case object `c6gn.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_MEDIUM
  }
  case object `c6gn.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_LARGE
  }
  case object `c6gn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_XLARGE
  }
  case object `c6gn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_2_XLARGE
  }
  case object `c6gn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_4_XLARGE
  }
  case object `c6gn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_8_XLARGE
  }
  case object `c6gn.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_12_XLARGE
  }
  case object `c6gn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_GN_16_XLARGE
  }
  case object `c6i.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_LARGE
  }
  case object `c6i.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_XLARGE
  }
  case object `c6i.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_2_XLARGE
  }
  case object `c6i.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_4_XLARGE
  }
  case object `c6i.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_8_XLARGE
  }
  case object `c6i.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_12_XLARGE
  }
  case object `c6i.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_16_XLARGE
  }
  case object `c6i.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_24_XLARGE
  }
  case object `c6i.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_32_XLARGE
  }
  case object `c6i.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_I_METAL
  }
  case object `cc1.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.CC1_4_XLARGE
  }
  case object `cc2.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.CC2_8_XLARGE
  }
  case object `cg1.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.CG1_4_XLARGE
  }
  case object `cr1.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.CR1_8_XLARGE
  }
  case object `d2.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D2_XLARGE
  }
  case object `d2.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D2_2_XLARGE
  }
  case object `d2.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D2_4_XLARGE
  }
  case object `d2.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D2_8_XLARGE
  }
  case object `d3.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_XLARGE
  }
  case object `d3.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_2_XLARGE
  }
  case object `d3.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_4_XLARGE
  }
  case object `d3.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_8_XLARGE
  }
  case object `d3en.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_XLARGE
  }
  case object `d3en.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_2_XLARGE
  }
  case object `d3en.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_4_XLARGE
  }
  case object `d3en.6xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_6_XLARGE
  }
  case object `d3en.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_8_XLARGE
  }
  case object `d3en.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.D3_EN_12_XLARGE
  }
  case object `dl1.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.DL1_24_XLARGE
  }
  case object `f1.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.F1_2_XLARGE
  }
  case object `f1.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.F1_4_XLARGE
  }
  case object `f1.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.F1_16_XLARGE
  }
  case object `g2.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G2_2_XLARGE
  }
  case object `g2.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G2_8_XLARGE
  }
  case object `g3.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G3_4_XLARGE
  }
  case object `g3.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G3_8_XLARGE
  }
  case object `g3.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G3_16_XLARGE
  }
  case object `g3s.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G3_S_XLARGE
  }
  case object `g4ad.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_XLARGE
  }
  case object `g4ad.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_2_XLARGE
  }
  case object `g4ad.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_4_XLARGE
  }
  case object `g4ad.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_8_XLARGE
  }
  case object `g4ad.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_AD_16_XLARGE
  }
  case object `g4dn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_XLARGE
  }
  case object `g4dn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_2_XLARGE
  }
  case object `g4dn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_4_XLARGE
  }
  case object `g4dn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_8_XLARGE
  }
  case object `g4dn.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_12_XLARGE
  }
  case object `g4dn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_16_XLARGE
  }
  case object `g4dn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G4_DN_METAL
  }
  case object `g5.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_XLARGE
  }
  case object `g5.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_2_XLARGE
  }
  case object `g5.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_4_XLARGE
  }
  case object `g5.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_8_XLARGE
  }
  case object `g5.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_12_XLARGE
  }
  case object `g5.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_16_XLARGE
  }
  case object `g5.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_24_XLARGE
  }
  case object `g5.48xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_48_XLARGE
  }
  case object `g5g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_XLARGE
  }
  case object `g5g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_2_XLARGE
  }
  case object `g5g.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_4_XLARGE
  }
  case object `g5g.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_8_XLARGE
  }
  case object `g5g.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_16_XLARGE
  }
  case object `g5g.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.G5_G_METAL
  }
  case object `hi1.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.HI1_4_XLARGE
  }
  case object `hpc6a.48xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.HPC6_A_48_XLARGE
  }
  case object `hs1.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.HS1_8_XLARGE
  }
  case object `h1.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.H1_2_XLARGE
  }
  case object `h1.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.H1_4_XLARGE
  }
  case object `h1.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.H1_8_XLARGE
  }
  case object `h1.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.H1_16_XLARGE
  }
  case object `i2.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I2_XLARGE
  }
  case object `i2.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I2_2_XLARGE
  }
  case object `i2.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I2_4_XLARGE
  }
  case object `i2.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I2_8_XLARGE
  }
  case object `i3.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_LARGE
  }
  case object `i3.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_XLARGE
  }
  case object `i3.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_2_XLARGE
  }
  case object `i3.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_4_XLARGE
  }
  case object `i3.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_8_XLARGE
  }
  case object `i3.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_16_XLARGE
  }
  case object `i3.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_METAL
  }
  case object `i3en.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_LARGE
  }
  case object `i3en.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_XLARGE
  }
  case object `i3en.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_2_XLARGE
  }
  case object `i3en.3xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_3_XLARGE
  }
  case object `i3en.6xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_6_XLARGE
  }
  case object `i3en.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_12_XLARGE
  }
  case object `i3en.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_24_XLARGE
  }
  case object `i3en.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I3_EN_METAL
  }
  case object `im4gn.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_LARGE
  }
  case object `im4gn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_XLARGE
  }
  case object `im4gn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_2_XLARGE
  }
  case object `im4gn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_4_XLARGE
  }
  case object `im4gn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_8_XLARGE
  }
  case object `im4gn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IM4_GN_16_XLARGE
  }
  case object `inf1.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.INF1_XLARGE
  }
  case object `inf1.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.INF1_2_XLARGE
  }
  case object `inf1.6xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.INF1_6_XLARGE
  }
  case object `inf1.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.INF1_24_XLARGE
  }
  case object `is4gen.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_MEDIUM
  }
  case object `is4gen.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_LARGE
  }
  case object `is4gen.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_XLARGE
  }
  case object `is4gen.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_2_XLARGE
  }
  case object `is4gen.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_4_XLARGE
  }
  case object `is4gen.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.IS4_GEN_8_XLARGE
  }
  case object `m1.small` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M1_SMALL
  }
  case object `m1.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M1_MEDIUM
  }
  case object `m1.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M1_LARGE
  }
  case object `m1.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M1_XLARGE
  }
  case object `m2.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M2_XLARGE
  }
  case object `m2.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M2_2_XLARGE
  }
  case object `m2.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M2_4_XLARGE
  }
  case object `m3.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M3_MEDIUM
  }
  case object `m3.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M3_LARGE
  }
  case object `m3.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M3_XLARGE
  }
  case object `m3.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M3_2_XLARGE
  }
  case object `m4.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M4_LARGE
  }
  case object `m4.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M4_XLARGE
  }
  case object `m4.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M4_2_XLARGE
  }
  case object `m4.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M4_4_XLARGE
  }
  case object `m4.10xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M4_10_XLARGE
  }
  case object `m4.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M4_16_XLARGE
  }
  case object `m5.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_LARGE
  }
  case object `m5.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_XLARGE
  }
  case object `m5.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_2_XLARGE
  }
  case object `m5.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_4_XLARGE
  }
  case object `m5.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_8_XLARGE
  }
  case object `m5.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_12_XLARGE
  }
  case object `m5.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_16_XLARGE
  }
  case object `m5.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_24_XLARGE
  }
  case object `m5.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_METAL
  }
  case object `m5a.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_LARGE
  }
  case object `m5a.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_XLARGE
  }
  case object `m5a.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_2_XLARGE
  }
  case object `m5a.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_4_XLARGE
  }
  case object `m5a.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_8_XLARGE
  }
  case object `m5a.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_12_XLARGE
  }
  case object `m5a.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_16_XLARGE
  }
  case object `m5a.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_A_24_XLARGE
  }
  case object `m5ad.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_LARGE
  }
  case object `m5ad.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_XLARGE
  }
  case object `m5ad.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_2_XLARGE
  }
  case object `m5ad.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_4_XLARGE
  }
  case object `m5ad.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_8_XLARGE
  }
  case object `m5ad.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_12_XLARGE
  }
  case object `m5ad.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_16_XLARGE
  }
  case object `m5ad.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_AD_24_XLARGE
  }
  case object `m5d.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_LARGE
  }
  case object `m5d.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_XLARGE
  }
  case object `m5d.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_2_XLARGE
  }
  case object `m5d.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_4_XLARGE
  }
  case object `m5d.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_8_XLARGE
  }
  case object `m5d.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_12_XLARGE
  }
  case object `m5d.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_16_XLARGE
  }
  case object `m5d.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_24_XLARGE
  }
  case object `m5d.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_D_METAL
  }
  case object `m5dn.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_LARGE
  }
  case object `m5dn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_XLARGE
  }
  case object `m5dn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_2_XLARGE
  }
  case object `m5dn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_4_XLARGE
  }
  case object `m5dn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_8_XLARGE
  }
  case object `m5dn.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_12_XLARGE
  }
  case object `m5dn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_16_XLARGE
  }
  case object `m5dn.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_24_XLARGE
  }
  case object `m5dn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_DN_METAL
  }
  case object `m5n.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_LARGE
  }
  case object `m5n.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_XLARGE
  }
  case object `m5n.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_2_XLARGE
  }
  case object `m5n.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_4_XLARGE
  }
  case object `m5n.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_8_XLARGE
  }
  case object `m5n.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_12_XLARGE
  }
  case object `m5n.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_16_XLARGE
  }
  case object `m5n.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_24_XLARGE
  }
  case object `m5n.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_N_METAL
  }
  case object `m5zn.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_LARGE
  }
  case object `m5zn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_XLARGE
  }
  case object `m5zn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_2_XLARGE
  }
  case object `m5zn.3xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_3_XLARGE
  }
  case object `m5zn.6xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_6_XLARGE
  }
  case object `m5zn.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_12_XLARGE
  }
  case object `m5zn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M5_ZN_METAL
  }
  case object `m6a.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_LARGE
  }
  case object `m6a.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_XLARGE
  }
  case object `m6a.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_2_XLARGE
  }
  case object `m6a.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_4_XLARGE
  }
  case object `m6a.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_8_XLARGE
  }
  case object `m6a.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_12_XLARGE
  }
  case object `m6a.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_16_XLARGE
  }
  case object `m6a.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_24_XLARGE
  }
  case object `m6a.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_32_XLARGE
  }
  case object `m6a.48xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_48_XLARGE
  }
  case object `m6g.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_METAL
  }
  case object `m6g.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_MEDIUM
  }
  case object `m6g.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_LARGE
  }
  case object `m6g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_XLARGE
  }
  case object `m6g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_2_XLARGE
  }
  case object `m6g.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_4_XLARGE
  }
  case object `m6g.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_8_XLARGE
  }
  case object `m6g.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_12_XLARGE
  }
  case object `m6g.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_G_16_XLARGE
  }
  case object `m6gd.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_METAL
  }
  case object `m6gd.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_MEDIUM
  }
  case object `m6gd.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_LARGE
  }
  case object `m6gd.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_XLARGE
  }
  case object `m6gd.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_2_XLARGE
  }
  case object `m6gd.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_4_XLARGE
  }
  case object `m6gd.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_8_XLARGE
  }
  case object `m6gd.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_12_XLARGE
  }
  case object `m6gd.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_GD_16_XLARGE
  }
  case object `m6i.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_LARGE
  }
  case object `m6i.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_XLARGE
  }
  case object `m6i.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_2_XLARGE
  }
  case object `m6i.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_4_XLARGE
  }
  case object `m6i.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_8_XLARGE
  }
  case object `m6i.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_12_XLARGE
  }
  case object `m6i.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_16_XLARGE
  }
  case object `m6i.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_24_XLARGE
  }
  case object `m6i.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_32_XLARGE
  }
  case object `m6i.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_I_METAL
  }
  case object `mac1.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.MAC1_METAL
  }
  case object `p2.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P2_XLARGE
  }
  case object `p2.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P2_8_XLARGE
  }
  case object `p2.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P2_16_XLARGE
  }
  case object `p3.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P3_2_XLARGE
  }
  case object `p3.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P3_8_XLARGE
  }
  case object `p3.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P3_16_XLARGE
  }
  case object `p3dn.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P3_DN_24_XLARGE
  }
  case object `p4d.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P4_D_24_XLARGE
  }
  case object `r3.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R3_LARGE
  }
  case object `r3.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R3_XLARGE
  }
  case object `r3.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R3_2_XLARGE
  }
  case object `r3.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R3_4_XLARGE
  }
  case object `r3.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R3_8_XLARGE
  }
  case object `r4.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R4_LARGE
  }
  case object `r4.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R4_XLARGE
  }
  case object `r4.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R4_2_XLARGE
  }
  case object `r4.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R4_4_XLARGE
  }
  case object `r4.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R4_8_XLARGE
  }
  case object `r4.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R4_16_XLARGE
  }
  case object `r5.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_LARGE
  }
  case object `r5.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_XLARGE
  }
  case object `r5.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_2_XLARGE
  }
  case object `r5.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_4_XLARGE
  }
  case object `r5.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_8_XLARGE
  }
  case object `r5.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_12_XLARGE
  }
  case object `r5.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_16_XLARGE
  }
  case object `r5.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_24_XLARGE
  }
  case object `r5.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_METAL
  }
  case object `r5a.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_LARGE
  }
  case object `r5a.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_XLARGE
  }
  case object `r5a.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_2_XLARGE
  }
  case object `r5a.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_4_XLARGE
  }
  case object `r5a.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_8_XLARGE
  }
  case object `r5a.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_12_XLARGE
  }
  case object `r5a.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_16_XLARGE
  }
  case object `r5a.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_A_24_XLARGE
  }
  case object `r5ad.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_LARGE
  }
  case object `r5ad.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_XLARGE
  }
  case object `r5ad.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_2_XLARGE
  }
  case object `r5ad.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_4_XLARGE
  }
  case object `r5ad.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_8_XLARGE
  }
  case object `r5ad.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_12_XLARGE
  }
  case object `r5ad.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_16_XLARGE
  }
  case object `r5ad.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_AD_24_XLARGE
  }
  case object `r5b.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_LARGE
  }
  case object `r5b.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_XLARGE
  }
  case object `r5b.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_2_XLARGE
  }
  case object `r5b.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_4_XLARGE
  }
  case object `r5b.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_8_XLARGE
  }
  case object `r5b.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_12_XLARGE
  }
  case object `r5b.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_16_XLARGE
  }
  case object `r5b.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_24_XLARGE
  }
  case object `r5b.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_B_METAL
  }
  case object `r5d.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_LARGE
  }
  case object `r5d.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_XLARGE
  }
  case object `r5d.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_2_XLARGE
  }
  case object `r5d.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_4_XLARGE
  }
  case object `r5d.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_8_XLARGE
  }
  case object `r5d.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_12_XLARGE
  }
  case object `r5d.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_16_XLARGE
  }
  case object `r5d.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_24_XLARGE
  }
  case object `r5d.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_D_METAL
  }
  case object `r5dn.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_LARGE
  }
  case object `r5dn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_XLARGE
  }
  case object `r5dn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_2_XLARGE
  }
  case object `r5dn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_4_XLARGE
  }
  case object `r5dn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_8_XLARGE
  }
  case object `r5dn.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_12_XLARGE
  }
  case object `r5dn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_16_XLARGE
  }
  case object `r5dn.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_24_XLARGE
  }
  case object `r5dn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_DN_METAL
  }
  case object `r5n.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_LARGE
  }
  case object `r5n.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_XLARGE
  }
  case object `r5n.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_2_XLARGE
  }
  case object `r5n.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_4_XLARGE
  }
  case object `r5n.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_8_XLARGE
  }
  case object `r5n.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_12_XLARGE
  }
  case object `r5n.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_16_XLARGE
  }
  case object `r5n.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_24_XLARGE
  }
  case object `r5n.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R5_N_METAL
  }
  case object `r6g.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_MEDIUM
  }
  case object `r6g.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_LARGE
  }
  case object `r6g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_XLARGE
  }
  case object `r6g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_2_XLARGE
  }
  case object `r6g.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_4_XLARGE
  }
  case object `r6g.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_8_XLARGE
  }
  case object `r6g.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_12_XLARGE
  }
  case object `r6g.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_16_XLARGE
  }
  case object `r6g.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_G_METAL
  }
  case object `r6gd.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_MEDIUM
  }
  case object `r6gd.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_LARGE
  }
  case object `r6gd.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_XLARGE
  }
  case object `r6gd.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_2_XLARGE
  }
  case object `r6gd.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_4_XLARGE
  }
  case object `r6gd.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_8_XLARGE
  }
  case object `r6gd.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_12_XLARGE
  }
  case object `r6gd.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_16_XLARGE
  }
  case object `r6gd.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_GD_METAL
  }
  case object `r6i.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_LARGE
  }
  case object `r6i.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_XLARGE
  }
  case object `r6i.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_2_XLARGE
  }
  case object `r6i.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_4_XLARGE
  }
  case object `r6i.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_8_XLARGE
  }
  case object `r6i.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_12_XLARGE
  }
  case object `r6i.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_16_XLARGE
  }
  case object `r6i.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_24_XLARGE
  }
  case object `r6i.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_32_XLARGE
  }
  case object `r6i.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_I_METAL
  }
  case object `t1.micro` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T1_MICRO
  }
  case object `t2.nano` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T2_NANO
  }
  case object `t2.micro` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T2_MICRO
  }
  case object `t2.small` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T2_SMALL
  }
  case object `t2.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T2_MEDIUM
  }
  case object `t2.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T2_LARGE
  }
  case object `t2.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T2_XLARGE
  }
  case object `t2.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T2_2_XLARGE
  }
  case object `t3.nano` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_NANO
  }
  case object `t3.micro` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_MICRO
  }
  case object `t3.small` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_SMALL
  }
  case object `t3.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_MEDIUM
  }
  case object `t3.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_LARGE
  }
  case object `t3.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_XLARGE
  }
  case object `t3.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_2_XLARGE
  }
  case object `t3a.nano` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_NANO
  }
  case object `t3a.micro` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_MICRO
  }
  case object `t3a.small` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_SMALL
  }
  case object `t3a.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_MEDIUM
  }
  case object `t3a.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_LARGE
  }
  case object `t3a.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_XLARGE
  }
  case object `t3a.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T3_A_2_XLARGE
  }
  case object `t4g.nano` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_NANO
  }
  case object `t4g.micro` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_MICRO
  }
  case object `t4g.small` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_SMALL
  }
  case object `t4g.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_MEDIUM
  }
  case object `t4g.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_LARGE
  }
  case object `t4g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_XLARGE
  }
  case object `t4g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.T4_G_2_XLARGE
  }
  case object `u-6tb1.56xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_6_TB1_56_XLARGE
  }
  case object `u-6tb1.112xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_6_TB1_112_XLARGE
  }
  case object `u-9tb1.112xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_9_TB1_112_XLARGE
  }
  case object `u-12tb1.112xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_12_TB1_112_XLARGE
  }
  case object `u-6tb1.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_6_TB1_METAL
  }
  case object `u-9tb1.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_9_TB1_METAL
  }
  case object `u-12tb1.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_12_TB1_METAL
  }
  case object `u-18tb1.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_18_TB1_METAL
  }
  case object `u-24tb1.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_24_TB1_METAL
  }
  case object `vt1.3xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.VT1_3_XLARGE
  }
  case object `vt1.6xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.VT1_6_XLARGE
  }
  case object `vt1.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.VT1_24_XLARGE
  }
  case object `x1.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X1_16_XLARGE
  }
  case object `x1.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X1_32_XLARGE
  }
  case object `x1e.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_XLARGE
  }
  case object `x1e.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_2_XLARGE
  }
  case object `x1e.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_4_XLARGE
  }
  case object `x1e.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_8_XLARGE
  }
  case object `x1e.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_16_XLARGE
  }
  case object `x1e.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X1_E_32_XLARGE
  }
  case object `x2iezn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_2_XLARGE
  }
  case object `x2iezn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_4_XLARGE
  }
  case object `x2iezn.6xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_6_XLARGE
  }
  case object `x2iezn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_8_XLARGE
  }
  case object `x2iezn.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_12_XLARGE
  }
  case object `x2iezn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEZN_METAL
  }
  case object `x2gd.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_MEDIUM
  }
  case object `x2gd.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_LARGE
  }
  case object `x2gd.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_XLARGE
  }
  case object `x2gd.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_2_XLARGE
  }
  case object `x2gd.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_4_XLARGE
  }
  case object `x2gd.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_8_XLARGE
  }
  case object `x2gd.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_12_XLARGE
  }
  case object `x2gd.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_16_XLARGE
  }
  case object `x2gd.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_GD_METAL
  }
  case object `z1d.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_LARGE
  }
  case object `z1d.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_XLARGE
  }
  case object `z1d.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_2_XLARGE
  }
  case object `z1d.3xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_3_XLARGE
  }
  case object `z1d.6xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_6_XLARGE
  }
  case object `z1d.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_12_XLARGE
  }
  case object `z1d.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.Z1_D_METAL
  }
  case object `x2idn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IDN_16_XLARGE
  }
  case object `x2idn.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IDN_24_XLARGE
  }
  case object `x2idn.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IDN_32_XLARGE
  }
  case object `x2iedn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_XLARGE
  }
  case object `x2iedn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_2_XLARGE
  }
  case object `x2iedn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_4_XLARGE
  }
  case object `x2iedn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_8_XLARGE
  }
  case object `x2iedn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_16_XLARGE
  }
  case object `x2iedn.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_24_XLARGE
  }
  case object `x2iedn.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_32_XLARGE
  }
  case object `c6a.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_LARGE
  }
  case object `c6a.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_XLARGE
  }
  case object `c6a.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_2_XLARGE
  }
  case object `c6a.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_4_XLARGE
  }
  case object `c6a.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_8_XLARGE
  }
  case object `c6a.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_12_XLARGE
  }
  case object `c6a.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_16_XLARGE
  }
  case object `c6a.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_24_XLARGE
  }
  case object `c6a.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_32_XLARGE
  }
  case object `c6a.48xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_48_XLARGE
  }
  case object `c6a.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_A_METAL
  }
  case object `m6a.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_A_METAL
  }
  case object `i4i.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_LARGE
  }
  case object `i4i.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_XLARGE
  }
  case object `i4i.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_2_XLARGE
  }
  case object `i4i.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_4_XLARGE
  }
  case object `i4i.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_8_XLARGE
  }
  case object `i4i.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_16_XLARGE
  }
  case object `i4i.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_32_XLARGE
  }
  case object `i4i.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_I_METAL
  }
  case object `x2idn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IDN_METAL
  }
  case object `x2iedn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.X2_IEDN_METAL
  }
  case object `c7g.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_MEDIUM
  }
  case object `c7g.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_LARGE
  }
  case object `c7g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_XLARGE
  }
  case object `c7g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_2_XLARGE
  }
  case object `c7g.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_4_XLARGE
  }
  case object `c7g.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_8_XLARGE
  }
  case object `c7g.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_12_XLARGE
  }
  case object `c7g.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_16_XLARGE
  }
  case object `mac2.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.MAC2_METAL
  }
  case object `c6id.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_LARGE
  }
  case object `c6id.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_XLARGE
  }
  case object `c6id.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_2_XLARGE
  }
  case object `c6id.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_4_XLARGE
  }
  case object `c6id.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_8_XLARGE
  }
  case object `c6id.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_12_XLARGE
  }
  case object `c6id.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_16_XLARGE
  }
  case object `c6id.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_24_XLARGE
  }
  case object `c6id.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_32_XLARGE
  }
  case object `c6id.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_ID_METAL
  }
  case object `m6id.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_LARGE
  }
  case object `m6id.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_XLARGE
  }
  case object `m6id.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_2_XLARGE
  }
  case object `m6id.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_4_XLARGE
  }
  case object `m6id.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_8_XLARGE
  }
  case object `m6id.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_12_XLARGE
  }
  case object `m6id.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_16_XLARGE
  }
  case object `m6id.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_24_XLARGE
  }
  case object `m6id.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_32_XLARGE
  }
  case object `m6id.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_ID_METAL
  }
  case object `r6id.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_LARGE
  }
  case object `r6id.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_XLARGE
  }
  case object `r6id.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_2_XLARGE
  }
  case object `r6id.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_4_XLARGE
  }
  case object `r6id.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_8_XLARGE
  }
  case object `r6id.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_12_XLARGE
  }
  case object `r6id.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_16_XLARGE
  }
  case object `r6id.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_24_XLARGE
  }
  case object `r6id.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_32_XLARGE
  }
  case object `r6id.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_ID_METAL
  }
  case object `r6a.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_LARGE
  }
  case object `r6a.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_XLARGE
  }
  case object `r6a.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_2_XLARGE
  }
  case object `r6a.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_4_XLARGE
  }
  case object `r6a.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_8_XLARGE
  }
  case object `r6a.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_12_XLARGE
  }
  case object `r6a.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_16_XLARGE
  }
  case object `r6a.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_24_XLARGE
  }
  case object `r6a.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_32_XLARGE
  }
  case object `r6a.48xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_48_XLARGE
  }
  case object `r6a.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_A_METAL
  }
  case object `p4de.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.P4_DE_24_XLARGE
  }
  case object `u-3tb1.56xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_3_TB1_56_XLARGE
  }
  case object `u-18tb1.112xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_18_TB1_112_XLARGE
  }
  case object `u-24tb1.112xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.U_24_TB1_112_XLARGE
  }
  case object `trn1.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.TRN1_2_XLARGE
  }
  case object `trn1.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.TRN1_32_XLARGE
  }
  case object `hpc6id.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.HPC6_ID_32_XLARGE
  }
  case object `c6in.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_LARGE
  }
  case object `c6in.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_XLARGE
  }
  case object `c6in.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_2_XLARGE
  }
  case object `c6in.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_4_XLARGE
  }
  case object `c6in.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_8_XLARGE
  }
  case object `c6in.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_12_XLARGE
  }
  case object `c6in.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_16_XLARGE
  }
  case object `c6in.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_24_XLARGE
  }
  case object `c6in.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_32_XLARGE
  }
  case object `m6in.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_LARGE
  }
  case object `m6in.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_XLARGE
  }
  case object `m6in.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_2_XLARGE
  }
  case object `m6in.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_4_XLARGE
  }
  case object `m6in.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_8_XLARGE
  }
  case object `m6in.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_12_XLARGE
  }
  case object `m6in.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_16_XLARGE
  }
  case object `m6in.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_24_XLARGE
  }
  case object `m6in.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_32_XLARGE
  }
  case object `m6idn.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_LARGE
  }
  case object `m6idn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_XLARGE
  }
  case object `m6idn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_2_XLARGE
  }
  case object `m6idn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_4_XLARGE
  }
  case object `m6idn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_8_XLARGE
  }
  case object `m6idn.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_12_XLARGE
  }
  case object `m6idn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_16_XLARGE
  }
  case object `m6idn.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_24_XLARGE
  }
  case object `m6idn.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_32_XLARGE
  }
  case object `r6in.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_LARGE
  }
  case object `r6in.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_XLARGE
  }
  case object `r6in.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_2_XLARGE
  }
  case object `r6in.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_4_XLARGE
  }
  case object `r6in.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_8_XLARGE
  }
  case object `r6in.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_12_XLARGE
  }
  case object `r6in.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_16_XLARGE
  }
  case object `r6in.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_24_XLARGE
  }
  case object `r6in.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_32_XLARGE
  }
  case object `r6idn.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_LARGE
  }
  case object `r6idn.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_XLARGE
  }
  case object `r6idn.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_2_XLARGE
  }
  case object `r6idn.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_4_XLARGE
  }
  case object `r6idn.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_8_XLARGE
  }
  case object `r6idn.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_12_XLARGE
  }
  case object `r6idn.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_16_XLARGE
  }
  case object `r6idn.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_24_XLARGE
  }
  case object `r6idn.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_32_XLARGE
  }
  case object `c7g.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C7_G_METAL
  }
  case object `m7g.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_MEDIUM
  }
  case object `m7g.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_LARGE
  }
  case object `m7g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_XLARGE
  }
  case object `m7g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_2_XLARGE
  }
  case object `m7g.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_4_XLARGE
  }
  case object `m7g.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_8_XLARGE
  }
  case object `m7g.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_12_XLARGE
  }
  case object `m7g.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_16_XLARGE
  }
  case object `m7g.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M7_G_METAL
  }
  case object `r7g.medium` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_MEDIUM
  }
  case object `r7g.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_LARGE
  }
  case object `r7g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_XLARGE
  }
  case object `r7g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_2_XLARGE
  }
  case object `r7g.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_4_XLARGE
  }
  case object `r7g.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_8_XLARGE
  }
  case object `r7g.12xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_12_XLARGE
  }
  case object `r7g.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_16_XLARGE
  }
  case object `r7g.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R7_G_METAL
  }
  case object `c6in.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.C6_IN_METAL
  }
  case object `m6in.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IN_METAL
  }
  case object `m6idn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.M6_IDN_METAL
  }
  case object `r6in.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IN_METAL
  }
  case object `r6idn.metal` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.R6_IDN_METAL
  }
  case object `inf2.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.INF2_XLARGE
  }
  case object `inf2.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.INF2_8_XLARGE
  }
  case object `inf2.24xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.INF2_24_XLARGE
  }
  case object `inf2.48xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.INF2_48_XLARGE
  }
  case object `trn1n.32xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.TRN1_N_32_XLARGE
  }
  case object `i4g.large` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_LARGE
  }
  case object `i4g.xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_XLARGE
  }
  case object `i4g.2xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_2_XLARGE
  }
  case object `i4g.4xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_4_XLARGE
  }
  case object `i4g.8xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_8_XLARGE
  }
  case object `i4g.16xlarge` extends zio.aws.ec2.model.InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceType =
      software.amazon.awssdk.services.ec2.model.InstanceType.I4_G_16_XLARGE
  }
}
