package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceStateChange(
    currentState: Optional[zio.aws.ec2.model.InstanceState] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    previousState: Optional[zio.aws.ec2.model.InstanceState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceStateChange = {
    import InstanceStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceStateChange
      .builder()
      .optionallyWith(currentState.map(value => value.buildAwsValue()))(
        _.currentState
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(previousState.map(value => value.buildAwsValue()))(
        _.previousState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceStateChange.ReadOnly =
    zio.aws.ec2.model.InstanceStateChange.wrap(buildAwsValue())
}
object InstanceStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceStateChange =
      zio.aws.ec2.model.InstanceStateChange(
        currentState.map(value => value.asEditable),
        instanceId.map(value => value),
        previousState.map(value => value.asEditable)
      )
    def currentState: Optional[zio.aws.ec2.model.InstanceState.ReadOnly]
    def instanceId: Optional[String]
    def previousState: Optional[zio.aws.ec2.model.InstanceState.ReadOnly]
    def getCurrentState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("currentState", currentState)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPreviousState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("previousState", previousState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStateChange
  ) extends zio.aws.ec2.model.InstanceStateChange.ReadOnly {
    override val currentState
        : Optional[zio.aws.ec2.model.InstanceState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentState())
        .map(value => zio.aws.ec2.model.InstanceState.wrap(value))
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val previousState
        : Optional[zio.aws.ec2.model.InstanceState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousState())
        .map(value => zio.aws.ec2.model.InstanceState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStateChange
  ): zio.aws.ec2.model.InstanceStateChange.ReadOnly = new Wrapper(impl)
}
