package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInstanceTypesFromInstanceRequirementsRequest(
    architectureTypes: Iterable[zio.aws.ec2.model.ArchitectureType],
    virtualizationTypes: Iterable[zio.aws.ec2.model.VirtualizationType],
    instanceRequirements: zio.aws.ec2.model.InstanceRequirementsRequest,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest = {
    import GetInstanceTypesFromInstanceRequirementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
      .builder()
      .architectureTypesWithStrings(architectureTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .virtualizationTypesWithStrings(virtualizationTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .instanceRequirements(instanceRequirements.buildAwsValue())
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest.ReadOnly =
    zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
      .wrap(buildAwsValue())
}
object GetInstanceTypesFromInstanceRequirementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest =
      zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest(
        architectureTypes,
        virtualizationTypes,
        instanceRequirements.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def architectureTypes: List[zio.aws.ec2.model.ArchitectureType]
    def virtualizationTypes: List[zio.aws.ec2.model.VirtualizationType]
    def instanceRequirements
        : zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getArchitectureTypes
        : ZIO[Any, Nothing, List[zio.aws.ec2.model.ArchitectureType]] =
      ZIO.succeed(architectureTypes)
    def getVirtualizationTypes
        : ZIO[Any, Nothing, List[zio.aws.ec2.model.VirtualizationType]] =
      ZIO.succeed(virtualizationTypes)
    def getInstanceRequirements: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly
    ] = ZIO.succeed(instanceRequirements)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
  ) extends zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest.ReadOnly {
    override val architectureTypes: List[zio.aws.ec2.model.ArchitectureType] =
      impl
        .architectureTypes()
        .asScala
        .map { item =>
          zio.aws.ec2.model.ArchitectureType.wrap(item)
        }
        .toList
    override val virtualizationTypes
        : List[zio.aws.ec2.model.VirtualizationType] = impl
      .virtualizationTypes()
      .asScala
      .map { item =>
        zio.aws.ec2.model.VirtualizationType.wrap(item)
      }
      .toList
    override val instanceRequirements
        : zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly =
      zio.aws.ec2.model.InstanceRequirementsRequest
        .wrap(impl.instanceRequirements())
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
  ): zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest.ReadOnly =
    new Wrapper(impl)
}
