package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FleetLaunchTemplateConfigRequest(
    launchTemplateSpecification: Optional[
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest
    ] = Optional.Absent,
    overrides: Optional[
      Iterable[zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest = {
    import FleetLaunchTemplateConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest
      .builder()
      .optionallyWith(
        launchTemplateSpecification.map(value => value.buildAwsValue())
      )(_.launchTemplateSpecification)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly =
    zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.wrap(buildAwsValue())
}
object FleetLaunchTemplateConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetLaunchTemplateConfigRequest =
      zio.aws.ec2.model.FleetLaunchTemplateConfigRequest(
        launchTemplateSpecification.map(value => value.asEditable),
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchTemplateSpecification: Optional[
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly
    ]
    def overrides: Optional[
      List[zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly]
    ]
    def getLaunchTemplateSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateSpecification",
      launchTemplateSpecification
    )
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest
  ) extends zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly {
    override val launchTemplateSpecification: Optional[
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateSpecification())
      .map(value =>
        zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.wrap(value)
      )
    override val overrides: Optional[
      List[zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.overrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest
  ): zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
