package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableTransitGatewayRouteTablePropagationResponse(
    propagation: Optional[zio.aws.ec2.model.TransitGatewayPropagation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse = {
    import EnableTransitGatewayRouteTablePropagationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse
      .builder()
      .optionallyWith(propagation.map(value => value.buildAwsValue()))(
        _.propagation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.ReadOnly =
    zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse
      .wrap(buildAwsValue())
}
object EnableTransitGatewayRouteTablePropagationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse =
      zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse(
        propagation.map(value => value.asEditable)
      )
    def propagation
        : Optional[zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly]
    def getPropagation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly
    ] = AwsError.unwrapOptionField("propagation", propagation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse
  ) extends zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.ReadOnly {
    override val propagation
        : Optional[zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagation())
        .map(value => zio.aws.ec2.model.TransitGatewayPropagation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse
  ): zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.ReadOnly =
    new Wrapper(impl)
}
