package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateTransitGatewayRouteTableResponse(
    association: Optional[zio.aws.ec2.model.TransitGatewayAssociation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse = {
    import DisassociateTransitGatewayRouteTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse
      .wrap(buildAwsValue())
}
object DisassociateTransitGatewayRouteTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse =
      zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse(
        association.map(value => value.asEditable)
      )
    def association
        : Optional[zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse
  ) extends zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.ReadOnly {
    override val association
        : Optional[zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.association())
        .map(value => zio.aws.ec2.model.TransitGatewayAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse
  ): zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.ReadOnly =
    new Wrapper(impl)
}
